/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class Constants {
    public static final Ordering<String> CASE_INSENSITIVE_NULL_SAFE_ORDER = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Joiner path = Joiner.on((String)File.separator).useForNull("");
    private static final String END = null;
    public static String JOURNEYMAP_DIR = "journeymap";
    public static String CONFIG_DIR_LEGACY = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[0]);
    public static String CONFIG_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[]{Journeymap.JM_VERSION.toMajorMinorString(), END});
    public static String DATA_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"data", new Object[0]);
    public static String SP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.sp, new Object[]{END});
    public static String MP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.mp, new Object[]{END});
    public static String RESOURCE_PACKS_DEFAULT = "Default";
    private static String ICON_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"icon", new Object[0]);
    public static String ENTITY_ICON_DIR = path.join((Object)ICON_DIR, (Object)"entity", new Object[]{END});
    public static String WAYPOINT_ICON_DIR = path.join((Object)ICON_DIR, (Object)"waypoint", new Object[]{END});
    public static String THEME_ICON_DIR = path.join((Object)ICON_DIR, (Object)"theme", new Object[]{END});

    public static Locale getLocale() {
        Locale locale = Locale.getDefault();
        try {
            String lang = Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode();
            locale = new Locale(lang);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't determine locale from game settings, defaulting to " + locale);
        }
        return locale;
    }

    public static String getString(String key) {
        if (Minecraft.func_71410_x() == null) {
            return key;
        }
        try {
            String result = Constants.getTranslatedTextComponent(key).getString();
            if (!result.equals(key) || JourneymapClient.getInstance().isMapping().booleanValue()) {
                // empty if block
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static StringTextComponent getStringTextComponent(String key) {
        return new StringTextComponent(key);
    }

    public static TranslationTextComponent getTranslatedTextComponent(String key) {
        return new TranslationTextComponent(key);
    }

    public static TranslationTextComponent getTranslatedTextComponent(String key, Object ... vals) {
        return new TranslationTextComponent(key, vals);
    }

    public static IReorderingProcessor getFormattedText(String text, Style style, FontRenderer fontRenderer, int size) {
        StringTextComponent textComponent = Constants.getStringTextComponent(text);
        List toolTipList = LanguageMap.func_74808_a().func_244260_a(fontRenderer.func_238420_b_().func_238362_b_((ITextProperties)textComponent, size, style));
        return IReorderingProcessor.func_242241_a((List)toolTipList);
    }

    public static String getString(String key, Object ... params) {
        if (Minecraft.func_71410_x() == null) {
            return String.format("%s (%s)", key, Joiner.on((String)",").join(params));
        }
        try {
            String result = I18n.func_135052_a((String)key, (Object[])params);
            if (result.equals(key) && JourneymapClient.getInstance().isMapping().booleanValue()) {
                Journeymap.getLogger().warn("Message key not found: " + String.format("%s (%s)", key, Joiner.on((String)",").join(params)));
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static boolean safeEqual(String first, String second) {
        int result = CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second);
        if (result != 0) {
            return false;
        }
        return CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second) == 0;
    }

    public static ResourcePackList getResourcePacks() {
        ResourcePackList resourcepackrepository = null;
        try {
            resourcepackrepository = Minecraft.func_71410_x().func_195548_H();
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Can't get resource pack names: %s", LogFormatter.toString(t)));
        }
        return resourcepackrepository;
    }

    public static String getModNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ModInfo mod : ModList.get().getMods()) {
            if (!ModList.get().isLoaded(mod.getModId())) continue;
            list.add(String.format("%s:%s", mod.getDisplayName(), mod.getVersion()));
        }
        Collections.sort(list);
        return Joiner.on((String)", ").join(list);
    }

    public static String birthdayMessage() {
        Calendar today = Calendar.getInstance();
        int month = today.get(2);
        int date = today.get(5);
        if (month == 6 && date == 2) {
            return Constants.getString("jm.common.birthday", "techbrew");
        }
        if (month == 8 && date == 21) {
            return Constants.getString("jm.common.birthday", "mysticdrew");
        }
        if (month == 8 && date == 27) {
            return Constants.getString("jm.common.birthday", "gdude2002");
        }
        return null;
    }

    public static enum WorldType {
        mp,
        sp;

    }
}

