/*
 * Decompiled with CFR 0.152.
 */
package gg.chaldea.client.reset.packet.mixin;

import gg.chaldea.client.reset.packet.mixin.VanillaPacketFilterAccessor;
import io.netty.channel.ChannelHandler;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.network.NetworkFilters;
import net.minecraftforge.network.VanillaPacketFilter;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={NetworkFilters.class})
public class MixinNetworkFilters {
    @Shadow(remap=false)
    @Final
    private static Map<String, Function<NetworkManager, VanillaPacketFilter>> instances;
    @Shadow(remap=false)
    @Final
    private static Logger LOGGER;

    @Overwrite(remap=false)
    public static void injectIfNecessary(NetworkManager manager) {
        instances.forEach((key, filterFactory) -> {
            if (manager.channel().pipeline().get(key) != null) {
                return;
            }
            try {
                VanillaPacketFilter filter = (VanillaPacketFilter)filterFactory.apply(manager);
                if (((VanillaPacketFilterAccessor)filter).invokeIsNecessary(manager)) {
                    manager.channel().pipeline().addBefore("packet_handler", key, (ChannelHandler)filter);
                    LOGGER.debug("Injected {} into {}", (Object)filter, (Object)manager);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

