/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RetreatAndSwitchPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private boolean[] energySelection;
    private int benchIndex;

    public RetreatAndSwitchPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public RetreatAndSwitchPacket(BlockPos blockPos, boolean[] energySelection, int benchIndex) {
        this();
        this.blockPos = blockPos;
        this.energySelection = energySelection;
        this.benchIndex = benchIndex;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.writeInt(this.energySelection.length);
        for (boolean selection : this.energySelection) {
            buffer.writeBoolean(selection);
        }
        buffer.writeInt(this.benchIndex);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.energySelection = new boolean[buffer.readInt()];
        for (int i = 0; i < this.energySelection.length; ++i) {
            this.energySelection[i] = buffer.readBoolean();
        }
        this.benchIndex = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity e = context.getSender();
        ServerWorld w = e.func_71121_q();
        BattleOwnedTileEntityController b = (BattleOwnedTileEntityController)w.func_175625_s(this.blockPos);
        GameServerState server = b.getGameServer();
        PlayerServerState player = b.getGameServer().getPlayer(b.getGameServer().getCurrentTurn());
        if ((b.getGameServer().getGamePhase() == GamePhase.NormalTurn || b.getGameServer().getGamePhase() == GamePhase.FirstTurn) && player != null && player.getEntityPlayer() == e && server.isCurrentTurn(player)) {
            ArrayList<CommonCardState> attachments = new ArrayList<CommonCardState>();
            List energies = player.getActiveCard().getAttachments().stream().filter(CommonCardState::isEnergyEquivalence).collect(Collectors.toList());
            for (int i = 0; i < energies.size(); ++i) {
                if (!this.energySelection[i]) continue;
                attachments.add(player.getActiveCard().getAttachments().get(i));
            }
            b.requestRetreatAndSwitch(player, attachments, this.benchIndex);
        }
    }
}

