/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.network.packets.enums.PhaseAction;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class GenericActionRequestPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private PhaseAction action;
    private int playerIndex;
    private int actionIndex;
    private int actionSubindex;

    public GenericActionRequestPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public GenericActionRequestPacket(BlockPos blockPos, PhaseAction action, int playerIndex, int actionIndex, int actionSubindex) {
        this();
        this.blockPos = blockPos;
        this.action = action;
        this.playerIndex = playerIndex;
        this.actionIndex = actionIndex;
        this.actionSubindex = actionSubindex;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.writeInt(this.action.ordinal());
        buffer.writeInt(this.playerIndex);
        buffer.writeInt(this.actionIndex);
        buffer.writeInt(this.actionSubindex);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.action = PhaseAction.values()[buffer.readInt()];
        this.playerIndex = buffer.readInt();
        this.actionIndex = buffer.readInt();
        this.actionSubindex = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity e = context.getSender();
        ServerWorld w = e.func_71121_q();
        BattleOwnedTileEntityController b = (BattleOwnedTileEntityController)w.func_175625_s(this.blockPos);
        GameServerState server = b.getGameServer();
        switch (this.action) {
            case Exit: {
                return;
            }
            case EndTurn: {
                PlayerServerState player = server.getPlayer(this.playerIndex);
                if ((b.getGameServer().getGamePhase() == GamePhase.PreMatch || server.getCurrentTurn() == this.playerIndex) && player != null && player.getEntityPlayer() == e) {
                    b.requestEndTurn(player);
                }
                return;
            }
            case UseAbility: {
                if (server.getCurrentTurn() == this.playerIndex && server.getPlayer(this.playerIndex).getEntityPlayer() == e) {
                    b.requestAbility(this.playerIndex, BoardLocation.values()[this.actionIndex], this.actionSubindex);
                }
                return;
            }
            case UseAttack: {
                if (server.getCurrentTurn() == this.playerIndex && server.getPlayer(this.playerIndex).getEntityPlayer() == e) {
                    PlayerServerState player = server.getPlayer(server.getCurrentTurn());
                    if (player.isChoosingOppAttack()) {
                        b.requestPickAttack(this.playerIndex, this.actionIndex);
                    } else {
                        b.requestAttack(this.playerIndex, this.actionIndex);
                    }
                }
                return;
            }
            case Retreat: {
                if (server.getCurrentTurn() != this.playerIndex || server.getPlayer(this.playerIndex).getEntityPlayer() == e) {
                    // empty if block
                }
                return;
            }
            case Discard: {
                if (server.getCurrentTurn() != this.playerIndex || server.getPlayer(this.playerIndex).getEntityPlayer() != e) break;
                BoardLocation location = BoardLocation.values()[this.actionIndex];
                PlayerServerState player = server.getPlayer(server.getCurrentTurn());
                b.discard(player, location, this.actionSubindex);
            }
        }
    }
}

