/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class GenericGUIPacket
extends AbstractTCGPacket {
    private GUITypes type;
    private boolean isOpen;
    private BlockPos blockPos;

    public GenericGUIPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public GenericGUIPacket(GUITypes type, boolean isOpen, BlockPos blockPos) {
        this();
        this.type = type;
        this.isOpen = isOpen;
        this.blockPos = blockPos;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.type.ordinal());
        buffer.writeBoolean(this.isOpen);
        buffer.writeBoolean(this.blockPos != null);
        if (this.blockPos != null) {
            buffer.func_179255_a(this.blockPos);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.type = GUITypes.values()[buffer.readInt()];
        this.isOpen = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.blockPos = buffer.func_179259_c();
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        switch (this.type) {
            case DECK: {
                return;
            }
            case BATTLE: {
                PlayerServerState playerState;
                ServerWorld w;
                BattleOwnedTileEntityController b;
                if (!this.isOpen && (b = (BattleOwnedTileEntityController)(w = player.func_71121_q()).func_175625_s(this.blockPos)) != null && (playerState = b.getGameServer().getPlayer(player)) != null) {
                    playerState.setInGUI(false);
                }
                return;
            }
            case SPECTATE: {
                ServerWorld w;
                BattleOwnedTileEntityController b;
                if (!this.isOpen && (b = (BattleOwnedTileEntityController)(w = player.func_71121_q()).func_175625_s(this.blockPos)) != null) {
                    b.getGameServer().getSpectators().remove(player);
                }
                return;
            }
        }
    }

    public static enum GUITypes {
        DECK,
        BATTLE,
        SPECTATE;


        public static GUITypes spectating(boolean spectating) {
            return spectating ? SPECTATE : BATTLE;
        }
    }
}

