/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.item;

import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.container.DeckContainer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DeckItem
extends Item {
    public DeckItem() {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_TCG_DECKS).func_200917_a(1));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent textComponent = super.func_200295_i(stack);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("deck")) {
            ThemeDeck deck = ThemeDecks.get(stack.func_77978_p().func_74779_i("deck"));
            if (deck != null) {
                textComponent = new StringTextComponent("deck." + deck.getName().toLowerCase() + ".name");
            }
            if (stack.func_77978_p().func_74767_n("locked")) {
                textComponent = textComponent.func_230532_e_().func_240702_b_(" (").func_230529_a_((ITextComponent)new StringTextComponent("item.deck.locked")).func_240702_b_(")");
            }
        }
        return textComponent;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        List<ImmutableCard> cards = LogicHelper.getCards(null, stack);
        tooltip.add((ITextComponent)new StringTextComponent("Cards: " + cards.size()));
    }

    public int func_77626_a(ItemStack item) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && hand == Hand.MAIN_HAND) {
            DeckItem.openDeck(stack, (ServerPlayerEntity)player);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World level = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (!level.field_72995_K || player.func_213453_ef()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        if (player.field_71070_bA instanceof DeckContainer) {
            player.func_71053_j();
            return false;
        }
        return super.onDroppedByPlayer(item, player);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((IItemProvider)TCGItems.deck));
            for (ThemeDeck td : ThemeDecks.getAll()) {
                items.add((Object)td.getItemStack());
            }
        }
    }

    public static void openDeck(final ItemStack stack, final ServerPlayerEntity player) {
        if (stack.func_77973_b() instanceof DeckItem) {
            final Deck deck = Deck.readFromItemStack((PlayerEntity)player, stack);
            SimpleNamedContainerProvider containerProvider = new SimpleNamedContainerProvider((a, b, c) -> new DeckContainer(a, (PlayerEntity)player, player.field_71071_by, deck), (ITextComponent)new TranslationTextComponent(""));
            if (!player.field_71071_by.func_70431_c(stack)) {
                return;
            }
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, deck::writeToBuffer);
            player.field_71070_bA.func_75132_a(new IContainerListener(){

                public void func_71110_a(Container p_71110_1_, NonNullList<ItemStack> p_71110_2_) {
                    if (!player.field_71071_by.func_70431_c(stack)) {
                        return;
                    }
                    deck.writeToStack(stack);
                }

                public void func_71111_a(Container container, int slot, ItemStack item) {
                    if (!player.field_71071_by.func_70431_c(stack)) {
                        return;
                    }
                    if (slot >= deck.inventory.func_70302_i_()) {
                        return;
                    }
                    deck.inventory.func_70299_a(slot, item);
                    deck.writeToStack(stack);
                }

                public void func_71112_a(Container p_71112_1_, int p_71112_2_, int p_71112_3_) {
                    if (!player.field_71071_by.func_70431_c(stack)) {
                        return;
                    }
                    deck.writeToStack(stack);
                }
            });
        }
    }

    public static class Deck {
        public static final int size = 62;
        public Inventory inventory;
        private int slot;
        public boolean locked;

        public Deck(Inventory inventory, boolean locked, int slot) {
            this.inventory = inventory;
            this.locked = locked;
            this.slot = slot;
        }

        public int getSlot() {
            return this.slot;
        }

        public void writeToBuffer(PacketBuffer buffer) {
            CompoundNBT compound = new CompoundNBT();
            this.saveInventory(compound);
            buffer.func_150786_a(compound);
            buffer.writeBoolean(this.locked);
            if (this.slot >= 0) {
                buffer.writeInt(this.slot);
            }
        }

        public static Deck fromBuffer(PacketBuffer buffer) {
            CompoundNBT compound = buffer.func_150793_b();
            Inventory inventory = Deck.fromTag(compound);
            return new Deck(inventory, buffer.readBoolean(), buffer.readInt());
        }

        public void writeToStack(ItemStack stack) {
            CompoundNBT compound = stack.func_196082_o();
            this.saveInventory(compound);
            compound.func_74757_a("DeckLocked", this.locked);
        }

        public void saveInventory(CompoundNBT compoundNBT) {
            ListNBT list = new ListNBT();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", i);
                nbt.func_218657_a("item", (INBT)this.inventory.func_70301_a(i).func_77955_b(new CompoundNBT()));
                list.add((Object)nbt);
            }
            compoundNBT.func_218657_a("DeckItems", (INBT)list);
        }

        public static Inventory fromTag(CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c("DeckItems", 10);
            Inventory inventory = new Inventory(62);
            for (INBT inbt : list) {
                CompoundNBT listNBT = (CompoundNBT)inbt;
                inventory.func_70299_a(listNBT.func_74762_e("slot"), ItemStack.func_199557_a((CompoundNBT)listNBT.func_74775_l("item")));
            }
            return inventory;
        }

        public static Deck readFromItemStack(PlayerEntity player, ItemStack stack) {
            if (!(stack.func_77973_b() instanceof DeckItem)) {
                return null;
            }
            CompoundNBT compound = stack.func_77978_p();
            Inventory inventory = new Inventory(62);
            if (compound != null && compound.func_74764_b("DeckItems")) {
                inventory = Deck.fromTag(compound);
            }
            boolean locked = false;
            if (compound != null) {
                locked = compound.func_74767_n("DeckLocked");
            }
            int slot = -1;
            if (player != null) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack item = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    if (!Objects.equals(item, stack)) continue;
                    slot = i;
                    break;
                }
            }
            Deck deck = new Deck(inventory, locked, slot);
            inventory.func_110134_a(p_76316_1_ -> deck.writeToStack(stack));
            return deck;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }
}

