/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import net.minecraft.util.math.vector.Vector3f;

public class Transform
extends BasePowerEffect {
    public Transform() {
        super("Transform");
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    public boolean disableEvolution(PokemonCardState affecting, PokemonCardState pokemon, GameClientState client) {
        return pokemon == affecting;
    }

    @Override
    public boolean onCondition(PokemonCardState pokemon, PokemonCardState attacker, CardCondition cardCondition, GameServerState server) {
        for (PlayerServerState player : server.getPlayers()) {
            if (player.getActiveCard() != pokemon || this.isEnabled(pokemon, new GameClientState(server)) || server.getGamePhase() == GamePhase.PreMatch) continue;
            pokemon.transform(pokemon.getData(), pokemon.getStatus());
            pokemon.setHiddenAbility(null);
            pokemon.setOverrideModelColor(null);
            break;
        }
        return true;
    }

    @Override
    public void onPlay(PokemonCardState newPokemon, PlayerCommonState playingPlayer, PokemonCardState pokemon, PlayerServerState player, GameServerState server) {
        if (newPokemon == pokemon && player.getActiveCard() == pokemon && server.getOpponent(player).getActiveCard() != null && server.getGamePhase() != GamePhase.PreMatch) {
            pokemon.transform(server.getOpponent(player).getActiveCard().getData(), pokemon.getStatus());
            pokemon.setHiddenAbility(pokemon.getData().getAbility());
            pokemon.setOverrideModelColor(new Vector3f(0.44f, 0.25f, 0.63f));
        }
    }

    @Override
    public void onStartGame(PokemonCardState pokemon, GameServerState server) {
        for (PlayerServerState player : server.getPlayers()) {
            if (player.getActiveCard() != pokemon || !this.isEnabled(pokemon, new GameClientState(server))) continue;
            pokemon.transform(server.getOpponent(player).getActiveCard().getData(), pokemon.getStatus());
            pokemon.setHiddenAbility(pokemon.getData().getAbility());
            pokemon.setOverrideModelColor(new Vector3f(0.44f, 0.25f, 0.63f));
            break;
        }
    }

    @Override
    public void onSwitchActiveCard(PokemonCardState newActive, PokemonCardState oldActive, PlayerCommonState switchingPlayer, PokemonCardState pokemon, PlayerServerState player, GameServerState server) {
        if (player.getActiveCard() == pokemon && server.getOpponent(player).getActiveCard() != null && (switchingPlayer != player || newActive == pokemon) && server.getGamePhase() != GamePhase.PreMatch) {
            pokemon.transform(server.getOpponent(player).getActiveCard().getData(), pokemon.getStatus());
            pokemon.setHiddenAbility(pokemon.getData().getAbility());
            pokemon.setOverrideModelColor(new Vector3f(0.44f, 0.25f, 0.63f));
        } else if (player.getActiveCard() != pokemon && server.getGamePhase() != GamePhase.PreMatch) {
            pokemon.transform(pokemon.getData(), pokemon.getStatus());
            pokemon.setHiddenAbility(null);
            pokemon.setOverrideModelColor(null);
        }
    }

    @Override
    public boolean ignoreEnergyTypes() {
        return true;
    }
}

