/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.ArrayList;
import java.util.List;

public class FlipsMultiplyEffect
extends BaseAttackEffect {
    private static final String CODE = "FLIPS_MULTIPLY";
    private int flipCount;
    private Type type;
    public int counter = 0;

    public FlipsMultiplyEffect() {
        super(CODE);
    }

    @Override
    public List<CoinSide> flipCoin(List<CoinSide> currentResult, PokemonCardState pokemon, GameServerState server) {
        currentResult = new ArrayList<CoinSide>();
        int count = this.getCount(pokemon, server);
        if (count == -1) {
            while (true) {
                CoinSide toAdd = CoinSide.getRandom();
                currentResult.add(toAdd);
                if (toAdd != CoinSide.Tail) {
                    ++this.counter;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                currentResult.add(CoinSide.getRandom());
            }
        }
        return currentResult;
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        int damage = 0;
        for (int i = 0; i < server.getCoinFlip().getResults().size(); ++i) {
            if (server.getCoinFlip().getResults().get(i) != CoinSide.Head) continue;
            damage += attack.getData().getDamage();
        }
        attack.setDamage(damage);
    }

    private int getCount(PokemonCardState pokemon, GameServerState server) {
        int count = 0;
        switch (this.type) {
            case Exact: {
                count = this.flipCount;
                break;
            }
            case PerEnergy: {
                count = (int)pokemon.getAttachments().stream().filter(CommonCardState::isEnergyEquivalence).count();
                break;
            }
            case PerOppBench: {
                for (PokemonCardState state : server.getPlayer(server.getNextTurn()).getBenchCards()) {
                    if (state == null || state.getData() == null) continue;
                    ++count;
                }
                break;
            }
            case PerSelfBench: {
                for (PokemonCardState state : server.getPlayer(server.getCurrentTurn()).getBenchCards()) {
                    if (state == null || state.getData() == null) continue;
                    ++count;
                }
                break;
            }
            case UntilFail: {
                count = -1;
            }
        }
        return count;
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.flipCount = 0;
        if (args[1].equalsIgnoreCase("ENERGY") || args[1].equalsIgnoreCase("PER_ENERGY")) {
            this.type = Type.PerEnergy;
        } else if (args[1].equalsIgnoreCase("UNTILFAIL")) {
            this.type = Type.UntilFail;
        } else if (args[1].equalsIgnoreCase("PER_SELF_BENCH")) {
            this.type = Type.PerSelfBench;
        } else if (args[1].equalsIgnoreCase("PER_OPP_BENCH")) {
            this.type = Type.PerOppBench;
        } else {
            this.type = Type.Exact;
            this.flipCount = Integer.parseInt(args[1]);
        }
        return super.parse(args);
    }

    public static enum Type {
        Exact,
        PerEnergy,
        PerSelfBench,
        PerOppBench,
        UntilFail;

    }
}

