/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class ChangeResistanceEffect
extends BaseAttackEffect {
    private static final String CODE = "CHANGE_RESISTANCE";
    private boolean onMe;

    public ChangeResistanceEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        if (!this.hasResistance(server)) {
            return null;
        }
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "attack.effect.changeresistance.selector");
        for (ImmutableCard energyCard : Cards.getEnergyCards()) {
            selector.getCardList().add(new CardWithLocation(new CommonCardState(energyCard), false, null, 0));
        }
        return selector;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        if (!this.hasResistance(server)) {
            return true;
        }
        return parameters.size() == 1;
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (!this.hasResistance(server)) {
            return;
        }
        CommonCardState energy = (CommonCardState)parameters.get(0);
        PokemonCardState applyOn = server.getPlayer(this.onMe ? server.getCurrentTurn() : server.getNextTurn()).getActiveCard();
        applyOn.setResistance(energy.getMainEnergy());
    }

    protected boolean hasResistance(GameServerState server) {
        return server.getPlayer(this.onMe ? server.getCurrentTurn() : server.getNextTurn()).getActiveCard().getResistance() != null;
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.onMe = args[1].equalsIgnoreCase("SELF");
        return super.parse(args);
    }
}

