/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import java.util.Arrays;
import java.util.List;

public enum CardCondition {
    POISONED("Poisoned", new String[]{"POISON"}),
    PARALYZED("Paralyzed", new String[]{"PARALYSED", "PARALYSE", "PARALYZE"}),
    ASLEEP("Asleep", new String[]{"SLEEP"}),
    BURNT("Burnt", new String[]{"BURN"}),
    CONFUSED("Confused", new String[]{"CONFUSE"});

    private final String asString;
    private final List<String> dbAliases;

    private CardCondition(String name, String[] dbAliases) {
        this.asString = name;
        this.dbAliases = Arrays.asList(dbAliases);
    }

    public String getName() {
        return this.asString;
    }

    public static CardCondition getFromDbString(String effect) {
        for (CardCondition cardCondition : CardCondition.values()) {
            if (!cardCondition.toString().equals(effect) && !cardCondition.dbAliases.contains(effect)) continue;
            return cardCondition;
        }
        return null;
    }
}

