/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure.type;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.world.structure.AbstractPixelmonStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ShrineStructure
extends AbstractPixelmonStructure<NoFeatureConfig> {
    private final String structure;
    private final Biome.Category category;

    public ShrineStructure(String structure, Biome.Category category) {
        super(NoFeatureConfig.field_236558_a_);
        this.structure = structure;
        this.category = category;
    }

    @Override
    public boolean isSuitable(Biome.Category category, String name) {
        if (name.contains("ultra")) {
            return false;
        }
        return this.category == category;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator generator, BiomeProvider source, long seed, SharedSeedRandom random, int chunkX, int chunkZ, Biome biome, ChunkPos pos, NoFeatureConfig config) {
        if (biome.func_201856_r() != this.category) {
            return false;
        }
        return RandomHelper.getRandomChance(PixelmonConfigProxy.getStructures().getIceShrineSpawnRates());
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (structure1, chunkX, chunkZ, boundingBox, referenceIn, seedIn) -> {
            Start start = new Start((Structure<NoFeatureConfig>)structure1, chunkX, chunkZ, boundingBox, referenceIn, seedIn);
            start.setStructure(this.structure);
            return start;
        };
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        private String structure;

        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingBox, int referenceIn, long seedIn) {
            super(structure, chunkX, chunkZ, boundingBox, referenceIn, seedIn);
        }

        public void setStructure(String structure) {
            this.structure = structure;
        }

        public void generatePieces(DynamicRegistries registry, ChunkGenerator generator, TemplateManager template, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            BlockPos blockPos = new BlockPos(chunkX * 16 + this.field_214631_d.nextInt(8), 0, chunkZ * 16 + this.field_214631_d.nextInt(8));
            JigsawManager.func_242837_a((DynamicRegistries)registry, (VillageConfig)new VillageConfig(() -> (JigsawPattern)registry.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("pixelmon", this.structure + "/start_pool")), 10), AbstractVillagePiece::new, (ChunkGenerator)generator, (TemplateManager)template, (BlockPos)blockPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            this.field_75075_a.forEach(piece -> {
                piece.func_181138_a(0, 1, 0);
                --piece.func_74874_b().field_78895_b;
            });
            if (!this.field_75075_a.isEmpty()) {
                Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
                int xOffset = blockPos.func_177958_n() - structureCenter.func_177958_n();
                int zOffset = blockPos.func_177952_p() - structureCenter.func_177952_p();
                for (StructurePiece structurePiece : this.field_75075_a) {
                    structurePiece.func_181138_a(xOffset, 0, zOffset);
                }
            }
            this.func_202500_a();
        }
    }
}

