/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class FireStoneOreFeature
extends Feature<NoFeatureConfig> {
    private static final Tags.IOptionalNamedTag<Block> NO_REPLACE_TAG = BlockTags.createOptional((ResourceLocation)new ResourceLocation("pixelmon", "firestone_ore_irreplaceable"));

    public FireStoneOreFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, Random rand, BlockPos pos) {
        int y = this.findTopLavaBlock(world, pos);
        if (world.func_180495_p(pos = new BlockPos(pos.func_177958_n(), ++y, pos.func_177952_p())).func_185904_a() == Material.field_151579_a) {
            for (int i = 1; i < 10; ++i) {
                BlockState state = world.func_180495_p(pos = new BlockPos(pos.func_177958_n(), ++y, pos.func_177952_p()));
                if (state.func_185904_a() == Material.field_151579_a || !this.canReplaceBlock(state)) continue;
                world.func_180501_a(pos, PixelmonBlocks.fire_stone_ore.func_176223_P(), 18);
                return true;
            }
        }
        return false;
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        for (int i = 0; i < 30; ++i) {
            int zPos;
            int xPos = random.nextInt(16) + chunkX * 16;
            if (!this.hasLava(world, new BlockPos(xPos, 0, zPos = random.nextInt(16) + chunkZ * 16))) continue;
            this.generate(world, random, new BlockPos(xPos, 0, zPos));
        }
        return true;
    }

    private boolean hasLava(ISeedReader world, BlockPos pos) {
        for (int i = 0; i < 30; ++i) {
            if (world.func_180495_p(new BlockPos(pos.func_177958_n(), i, pos.func_177952_p())).func_177230_c() != Blocks.field_150353_l) continue;
            return true;
        }
        return false;
    }

    private int findTopLavaBlock(ISeedReader world, BlockPos pos) {
        for (int i = 0; i < 30; ++i) {
            if (world.func_180495_p(new BlockPos(pos.func_177958_n(), i, pos.func_177952_p())).func_177230_c() != Blocks.field_150353_l) continue;
            return i;
        }
        return -1;
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.func_235714_a_(NO_REPLACE_TAG);
    }
}

