/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.dimension.ultraspace;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UltraSpaceBiomeProvider
extends BiomeProvider {
    public static final Codec<UltraSpaceBiomeProvider> CODEC = RecordCodecBuilder.create(p_235302_0_ -> p_235302_0_.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(p_235304_0_ -> p_235304_0_.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(p_242637_0_ -> p_242637_0_.biomes)).apply((Applicative)p_235302_0_, p_235302_0_.stable(UltraSpaceBiomeProvider::new)));
    private final Layer noiseBiomeLayer;
    private static final List<RegistryKey<Biome>> POSSIBLE_BIOMES = ImmutableList.of((Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)ResourceLocationHelper.of("pixelmon:ultra_deep_sea")), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)ResourceLocationHelper.of("pixelmon:ultra_desert")));
    private final long seed;
    private final boolean legacyBiomeInitLayer;
    private final boolean largeBiomes;
    private final Registry<Biome> biomes;

    public UltraSpaceBiomeProvider(long seed, Registry<Biome> p_i241958_5_) {
        super(POSSIBLE_BIOMES.stream().map(p_242638_1_ -> () -> (Biome)p_i241958_5_.func_243576_d(p_242638_1_)));
        this.seed = seed;
        this.legacyBiomeInitLayer = false;
        this.largeBiomes = false;
        this.biomes = p_i241958_5_;
        this.noiseBiomeLayer = LayerUtil.func_237215_a_((long)seed, (boolean)false, (int)4, (int)4);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new UltraSpaceBiomeProvider(seed, this.biomes);
    }

    public Biome func_225526_b_(int p_225526_1_, int p_225526_2_, int p_225526_3_) {
        return this.noiseBiomeLayer.func_242936_a(this.biomes, p_225526_1_, p_225526_3_);
    }

    public List<Biome> func_235203_c_() {
        return this.field_226837_c_;
    }
}

