/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.api.events.BeatTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.LostToTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonTradeEvent;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerListeners {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            if ((pps.getMegaItemsUnlocked().canMega() || pps.getMegaItemsUnlocked().canDynamax()) && pps.getMegaItem() == EnumMegaItem.Disabled) {
                pps.setMegaItem(EnumMegaItem.None, false);
            }
            QuestData data = pps.getQuestData(true);
            for (QuestProgress progress : data.getProgress()) {
                progress.sendTo(player);
            }
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(true).receive("DIMENSION", new Object[0]);
        }
    }

    @SubscribeEvent
    public void onDefeatTrainer(BeatTrainerEvent event) throws InvalidQuestArgsException {
        PlayerPartyStorage pps = StorageProxy.getParty(event.player);
        pps.getQuestData(true).receive("TRAINER_DEFEAT", new Object[]{event.trainer});
    }

    @SubscribeEvent
    public void onLoseToTrainer(LostToTrainerEvent event) throws InvalidQuestArgsException {
        PlayerPartyStorage pps = StorageProxy.getParty(event.player);
        pps.getQuestData(true).receive("TRAINER_DEFEATED_BY", new Object[]{event.trainer});
    }

    @SubscribeEvent
    public void onPlayerTrade(PixelmonTradeEvent.Post event) throws InvalidQuestArgsException {
        if (event.getPlayer1() instanceof ServerPlayerEntity) {
            ServerPlayerEntity p1 = (ServerPlayerEntity)event.getPlayer1();
            ServerPlayerEntity p2 = (ServerPlayerEntity)event.getPlayer2();
            PlayerPartyStorage pps1 = StorageProxy.getParty(p1);
            PlayerPartyStorage pps2 = StorageProxy.getParty(p2);
            pps1.getQuestData(false).receive("POKEMON_TRADE_GIVE", event.getPokemon1());
            pps1.getQuestData(true).receive("POKEMON_TRADE_GET", event.getPokemon2());
            pps2.getQuestData(false).receive("POKEMON_TRADE_GET", event.getPokemon2());
            pps2.getQuestData(true).receive("POKEMON_TRADE_GIVE", event.getPokemon1());
        }
    }
}

