/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm.editor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.QuestEditorItem;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.ResetQuestsPacket;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ReloadQuestDataPacket
extends AbstractPixelmonPacket {
    public ReloadQuestDataPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        if (QuestEditorItem.checkPermission((PlayerEntity)player)) {
            try {
                for (ServerPlayerEntity playerMP : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                    NetworkHelper.sendPacket(new ResetQuestsPacket(), playerMP);
                    PlayerPartyStorage pps = StorageProxy.getParty(playerMP);
                    QuestData data = pps.getQuestData();
                    for (QuestProgress progress : data.getProgress()) {
                        progress.invalidate();
                        progress.getQuest();
                        progress.sendTo(playerMP);
                    }
                }
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error(e.toString());
            }
        }
    }
}

