/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.rendering.QuestResources;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuestMarkerRenderer {
    @SubscribeEvent
    public void onRenderEvent(RenderLivingEvent.Post event) {
        MatrixStack matrix = event.getMatrixStack();
        IRenderTypeBuffer buffer = event.getBuffers();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        for (QuestProgressClient progress : QuestDataClient.getInstance().getQuests()) {
            for (QuestMarker marker : progress.getMarkers()) {
                if (!Objects.equals(marker.dim, mc.field_71441_e.func_234923_W_()) || marker.uuid == null || !event.getEntity().func_110124_au().equals(marker.uuid)) continue;
                LivingEntity entity = event.getEntity();
                double x = (float)(entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)mc.func_184121_ak());
                double y = (double)((float)(entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)mc.func_184121_ak()) + entity.func_70047_e()) + 0.8;
                double z = (float)(entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)mc.func_184121_ak());
                this.renderMarker(matrix, buffer, progress, marker, mc, x, y, z);
            }
        }
    }

    @SubscribeEvent
    public void onPostRender(RenderWorldLastEvent event) {
        MatrixStack matrix = event.getMatrixStack();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        for (QuestProgressClient progress : QuestDataClient.getInstance().getQuests()) {
            for (QuestMarker marker : progress.getMarkers()) {
                if (!Objects.equals(marker.dim, mc.field_71441_e.func_234923_W_()) || marker.uuid != null) continue;
                this.renderMarker(matrix, (IRenderTypeBuffer)buffer, progress, marker, mc, marker.x, marker.y, marker.z);
            }
        }
        buffer.func_228461_a_();
    }

    private void renderMarker(MatrixStack matrix, IRenderTypeBuffer buffer, QuestProgressClient progress, QuestMarker marker, Minecraft mc, double x, double y, double z) {
        matrix.func_227860_a_();
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        QuestColor qc = marker.getColor(mc.field_71441_e.func_72820_D());
        matrix.func_227861_a_(0.0, 2.5, 0.0);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
        float angle = (float)(Math.atan2(z - view.field_72449_c, x - view.field_72450_a) * 180.0 / Math.PI) + 90.0f;
        matrix.func_227863_a_(QuaternionHelper.fromEuler(angle, 0.0f, 0.0f, 1.0f));
        matrix.func_227862_a_(0.075f, 0.075f, 0.075f);
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(QuestResources.getMarkerTexture(progress, marker)));
        ((GenericSmdModel)((Object)QuestResources.getMarkerModel(marker).getModel())).getModel().animate();
        QuestResources.getMarkerModel(marker).render(matrix, vertices, 0xF000F0, OverlayTexture.field_229196_a_, qc.floatR(), qc.floatG(), qc.floatB(), 1.0f);
        matrix.func_227865_b_();
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        QuestDataClient.getInstance().clear();
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        QuestDataClient.getInstance().clear();
    }
}

