/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Gluttony;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Ripen;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Confusion;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HealFixed;
import com.pixelmonmod.pixelmon.items.HealFraction;
import com.pixelmonmod.pixelmon.items.IHealHP;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import com.pixelmonmod.pixelmon.items.medicine.MedicinePotion;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BerryRestoreHPItem
extends BerryItem {
    public final BattleStatsType confusedStat;
    private final MedicinePotion healMethod;

    public BerryRestoreHPItem(Item.Properties properties, BerryType berry, BattleStatsType confusedStat) {
        super(properties, EnumHeldItems.berryRestoreHP, berry);
        this.confusedStat = confusedStat;
        this.healMethod = new MedicinePotion(this.getHealAmount());
    }

    @Override
    public boolean interact(PixelmonEntity pokemon, ItemStack itemstack, PlayerEntity player) {
        return this.healMethod.useMedicine(new DelegateLink(pokemon.getPokemon()));
    }

    @Override
    public void tookDamage(PixelmonWrapper attacker, PixelmonWrapper pokemon, float damage, DamageTypeEnum damageType) {
        if (pokemon.isAlive() && pokemon.getHealthPercent() <= (float)this.getThreshold(pokemon)) {
            this.eatBerry(pokemon);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.getHealthPercent() <= (float)this.getThreshold(newPokemon)) {
            this.eatBerry(newPokemon);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        this.applySwitchInEffect(pw);
    }

    @Override
    public void eatBerry(PixelmonWrapper pokemon) {
        if (BerryRestoreHPItem.canEatBerry(pokemon) && this.healPokemon(pokemon)) {
            super.eatBerry(pokemon);
            pokemon.consumeItem();
        }
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        if (!this.healPokemon(targetWrapper)) {
            userWrapper.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
        }
        return super.useFromBag(userWrapper, targetWrapper, stack);
    }

    public boolean healPokemon(PixelmonWrapper pokemon) {
        boolean ripened = pokemon.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Ripen.class);
        if (this.healMethod.useMedicine(new WrapperLink(pokemon), ripened ? 2.0 : 1.0)) {
            String nickname = pokemon.getNickname();
            pokemon.bc.sendToAll("pixelmon.helditems.consumerestorehp", nickname, this.getLocalizedName());
            if (pokemon.getNature().getDecreasedStat() == this.confusedStat && pokemon.addStatus(new Confusion(), pokemon)) {
                pokemon.bc.sendToAll("pixelmon.effect.becameconfused", nickname);
            }
            if (ripened) {
                pokemon.bc.sendToAll("pixelmon.abilities.ripen", pokemon.getNickname(), this.getLocalizedName());
            }
            return true;
        }
        return false;
    }

    public IHealHP getHealAmount() {
        switch (this.getBerry()) {
            case SITRUS: {
                return new HealFraction(0.25f);
            }
            case ORAN: {
                return new HealFixed(10);
            }
        }
        return new HealFraction(0.33333334f);
    }

    public int getThreshold(PixelmonWrapper user) {
        switch (this.getBerry()) {
            case SITRUS: 
            case ORAN: {
                return 50;
            }
        }
        return user.getBattleAbility() instanceof Gluttony ? 50 : 25;
    }
}

