/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import com.pixelmonmod.pixelmon.items.heldItems.WhiteHerbItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BerryGinemaItem
extends BerryItem {
    public BerryGinemaItem(Item.Properties properties) {
        super(properties, EnumHeldItems.ginemaBerry, BerryType.GINEMA);
    }

    @Override
    public void onStatModified(PixelmonWrapper holder, PixelmonWrapper affected) {
        if (BerryGinemaItem.canEatBerry(affected) && affected.getBattleStats().isLoweredThisTurn()) {
            this.eatBerry(affected);
        }
    }

    @Override
    public void eatBerry(PixelmonWrapper affected) {
        if (WhiteHerbItem.healStats(affected)) {
            super.eatBerry(affected);
            affected.consumeItem();
        }
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        if (!WhiteHerbItem.healStats(userWrapper)) {
            userWrapper.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
        }
        return super.useFromBag(userWrapper, targetWrapper, stack);
    }
}

