/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.enums.TextJustification;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class UIElementItem
extends PixelmonItem {
    public static final String IMAGE = "UIImage";
    public static final String HOVER = "UIHoverImage";
    public static final String TEXT = "UIText";
    public static final String HOVER_TEXT = "UIHoverText";
    public static final String TEXT_JUSTIFICATION = "UITextJustification";
    public static final String TEXT_SCALE = "UITextScale";
    public static final String X_OFFSET = "UIXOffset";
    public static final String Y_OFFSET = "UIYOffset";
    public static final String X_OVERRIDE = "UIXOverride";
    public static final String Y_OVERRIDE = "UIYOverride";
    public static final String Z_LEVEL = "UIZLevel";
    public static final String IMAGE_WIDTH = "UIImageWidth";
    public static final String IMAGE_HEIGHT = "UIImageHeight";
    public static final String IMAGE_U = "UIImageU";
    public static final String IMAGE_V = "UIImageV";
    public static final String SCALE_X = "UIImageScaleX";
    public static final String SCALE_Y = "UIImageScaleY";
    public static final String ROTATION = "UIRotation";
    public static final String R = "UIImageR";
    public static final String G = "UIImageG";
    public static final String B = "UIImageB";
    public static final String A = "UIImageA";
    public static final String HR = "UIImageHR";
    public static final String HG = "UIImageHG";
    public static final String HB = "UIImageHB";
    public static final String HA = "UIImageHA";

    public UIElementItem() {
        super(new Item.Properties());
    }

    public static Builder builder() {
        return new Builder(new ItemStack((IItemProvider)PixelmonItems.ui_element));
    }

    public static Builder builder(ItemStack stack) {
        return new Builder(stack);
    }

    public static Optional<ResourceLocation> getImage(ItemStack stack, boolean hover) {
        return hover ? UIElementItem.getHoverImage(stack) : UIElementItem.getImage(stack);
    }

    public static Optional<ResourceLocation> getImage(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE)) {
            return Optional.empty();
        }
        ResourceLocation rl = ResourceLocationHelper.of(tag.func_74779_i(IMAGE));
        return Optional.of(rl);
    }

    public static Optional<ResourceLocation> getHoverImage(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(HOVER)) {
            return UIElementItem.getImage(stack);
        }
        ResourceLocation rl = ResourceLocationHelper.of(tag.func_74779_i(HOVER));
        return Optional.of(rl);
    }

    public static Optional<Integer> getXOffset(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(X_OFFSET)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(X_OFFSET));
    }

    public static Optional<Integer> getYOffset(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(Y_OFFSET)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(Y_OFFSET));
    }

    public static Optional<Integer> getXOverride(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(X_OVERRIDE)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(X_OVERRIDE));
    }

    public static Optional<Integer> getYOverride(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(Y_OVERRIDE)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(Y_OVERRIDE));
    }

    public static Optional<Integer> getZLevel(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(Z_LEVEL)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(Z_LEVEL));
    }

    public static Optional<Integer> getImageWidth(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_WIDTH)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(IMAGE_WIDTH));
    }

    public static Optional<Integer> getImageHeight(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_HEIGHT)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(IMAGE_HEIGHT));
    }

    public static Optional<Float> getImageU(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_U)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.func_74760_g(IMAGE_U)));
    }

    public static Optional<Float> getImageV(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_V)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.func_74760_g(IMAGE_V)));
    }

    public static Optional<float[]> getColor(ItemStack stack, boolean hover) {
        return hover ? UIElementItem.getHoverColor(stack) : UIElementItem.getColor(stack);
    }

    public static Optional<float[]> getColor(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(R)) {
            return Optional.empty();
        }
        return Optional.of(new float[]{tag.func_74760_g(R), tag.func_74760_g(G), tag.func_74760_g(B), tag.func_74760_g(A)});
    }

    public static Optional<float[]> getHoverColor(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(HR)) {
            return UIElementItem.getColor(stack);
        }
        return Optional.of(new float[]{tag.func_74760_g(HR), tag.func_74760_g(HG), tag.func_74760_g(HB), tag.func_74760_g(HA)});
    }

    public static Optional<String> getText(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEXT)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74779_i(TEXT));
    }

    public static Optional<String> getHoverText(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(HOVER_TEXT)) {
            return UIElementItem.getText(stack);
        }
        return Optional.of(tag.func_74779_i(HOVER_TEXT));
    }

    public static Optional<String> getText(ItemStack stack, boolean hover) {
        return hover ? UIElementItem.getHoverText(stack) : UIElementItem.getText(stack);
    }

    public static TextJustification getTextJustification(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEXT_JUSTIFICATION)) {
            return TextJustification.RIGHT;
        }
        return TextJustification.get(tag.func_74765_d(TEXT_JUSTIFICATION));
    }

    public static short getTextScale(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEXT_SCALE)) {
            return 12;
        }
        return tag.func_74765_d(TEXT_SCALE);
    }

    public static float[] getScale(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return new float[]{1.0f, 1.0f};
        }
        return new float[]{tag.func_74764_b(SCALE_X) ? tag.func_74760_g(SCALE_X) : 1.0f, tag.func_74764_b(SCALE_Y) ? tag.func_74760_g(SCALE_Y) : 1.0f};
    }

    public static float getRotation(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(ROTATION)) {
            return 0.0f;
        }
        return tag.func_74760_g(ROTATION);
    }

    public static class Builder {
        private final ItemStack stack;

        private Builder(ItemStack stack) {
            this.stack = stack;
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new CompoundNBT());
            }
        }

        public Builder setImage(String image) {
            this.stack.func_77978_p().func_74778_a(UIElementItem.IMAGE, image);
            return this;
        }

        public Builder setHoverImage(String image) {
            this.stack.func_77978_p().func_74778_a(UIElementItem.HOVER, image);
            return this;
        }

        public Builder setText(String text) {
            this.stack.func_77978_p().func_74778_a(UIElementItem.TEXT, text);
            return this;
        }

        public Builder setHoverText(String text) {
            this.stack.func_77978_p().func_74778_a(UIElementItem.HOVER_TEXT, text);
            return this;
        }

        public Builder setTextJustification(TextJustification justification) {
            this.stack.func_77978_p().func_74777_a(UIElementItem.TEXT_JUSTIFICATION, (short)(justification.ordinal() - 1));
            return this;
        }

        public Builder setTextScale(float scale) {
            this.stack.func_77978_p().func_74776_a(UIElementItem.TEXT_SCALE, scale);
            return this;
        }

        public Builder setPosOffset(int x, int y) {
            this.stack.func_77978_p().func_74768_a(UIElementItem.X_OFFSET, x);
            this.stack.func_77978_p().func_74768_a(UIElementItem.Y_OFFSET, y);
            return this;
        }

        public Builder setPosOverride(int x, int y) {
            this.stack.func_77978_p().func_74768_a(UIElementItem.X_OVERRIDE, x);
            this.stack.func_77978_p().func_74768_a(UIElementItem.Y_OVERRIDE, y);
            return this;
        }

        public Builder setZLevel(int zLevel) {
            this.stack.func_77978_p().func_74768_a(UIElementItem.Z_LEVEL, zLevel);
            return this;
        }

        public Builder setSize(int w, int h) {
            this.stack.func_77978_p().func_74768_a(UIElementItem.IMAGE_WIDTH, w);
            this.stack.func_77978_p().func_74768_a(UIElementItem.IMAGE_HEIGHT, h);
            return this;
        }

        public Builder setScale(float scale) {
            this.setScale(scale, scale);
            return this;
        }

        public Builder setScale(float x, float y) {
            this.stack.func_77978_p().func_74776_a(UIElementItem.SCALE_X, x);
            this.stack.func_77978_p().func_74776_a(UIElementItem.SCALE_Y, y);
            return this;
        }

        public Builder setRotation(float angle) {
            this.stack.func_77978_p().func_74776_a(UIElementItem.ROTATION, angle);
            return this;
        }

        public Builder setUV(float u, float v) {
            this.stack.func_77978_p().func_74776_a(UIElementItem.IMAGE_U, u);
            this.stack.func_77978_p().func_74776_a(UIElementItem.IMAGE_V, v);
            return this;
        }

        public Builder setColor(int r, int g, int b, int a) {
            return this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public Builder setColor(float r, float g, float b, float a) {
            this.stack.func_77978_p().func_74776_a(UIElementItem.R, r);
            this.stack.func_77978_p().func_74776_a(UIElementItem.G, g);
            this.stack.func_77978_p().func_74776_a(UIElementItem.B, b);
            this.stack.func_77978_p().func_74776_a(UIElementItem.A, a);
            return this;
        }

        public Builder setHoverColor(int r, int g, int b, int a) {
            return this.setHoverColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public Builder setHoverColor(float r, float g, float b, float a) {
            this.stack.func_77978_p().func_74776_a(UIElementItem.HR, r);
            this.stack.func_77978_p().func_74776_a(UIElementItem.HG, g);
            this.stack.func_77978_p().func_74776_a(UIElementItem.HB, b);
            this.stack.func_77978_p().func_74776_a(UIElementItem.HA, a);
            return this;
        }

        public ItemStack build() {
            return this.stack;
        }
    }
}

