/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ITrainerData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerChat;
import java.util.ArrayList;

public class TrainerData
implements ITrainerData {
    public BaseTrainer trainerType;
    int minLevel;
    int maxLevel;
    int minPartyPokemon;
    int maxPartyPokemon;
    public int winnings;
    ArrayList<PokemonBase> pokemonList = new ArrayList(6);
    ArrayList<String> names = new ArrayList();
    ArrayList<String> textures = new ArrayList();
    ArrayList<TrainerChat> chat = new ArrayList();
    public String id;

    public TrainerData(String id) {
        this.id = id;
    }

    void addName(String name) {
        this.names.add(name);
    }

    void addTexture(String texture) {
        this.textures.add(texture);
    }

    public void addPokemon(PokemonBase poke) {
        this.pokemonList.add(poke);
    }

    public void addChat(String opening, String win, String lose) {
        this.chat.add(new TrainerChat(opening, win, lose));
    }

    public ArrayList<Pokemon> getRandomParty() {
        ArrayList<PokemonBase> filteredForms;
        int numPokemon = RandomHelper.getRandomNumberBetween(this.minPartyPokemon, this.maxPartyPokemon);
        ArrayList<Pokemon> list = new ArrayList<Pokemon>();
        if (!PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
            filteredForms = new ArrayList();
            for (PokemonBase f : this.pokemonList) {
                if (!PixelmonConfigProxy.getSpawning().isGenerationEnabled(f.getSpecies().getGeneration())) continue;
                filteredForms.add(f);
            }
        } else {
            filteredForms = this.pokemonList;
        }
        if (filteredForms.isEmpty()) {
            Pixelmon.LOGGER.error("Tried to generate a random party on TrainerData \"" + this.id + "\" with no valid Pok\u00e9mon on the enabled generations!");
            return list;
        }
        for (int i = 0; i < numPokemon; ++i) {
            PokemonBase pkForm = RandomHelper.getRandomElementFromCollection(filteredForms);
            if (pkForm == null || pkForm.getSpecies() == null) continue;
            PokemonSpecification spec = PokemonSpecificationProxy.create(pkForm.getSpecies().getName());
            list.add(spec.create());
        }
        return list;
    }

    public int getRandomName() {
        return RandomHelper.getRandomNumberBetween(0, this.names.size() - 1);
    }

    public int getRandomChat() {
        return RandomHelper.getRandomNumberBetween(0, this.chat.size() - 1);
    }

    public int getRandomLevel() {
        return RandomHelper.getRandomNumberBetween(this.minLevel, this.maxLevel);
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMinPartyPokemon() {
        return this.minPartyPokemon;
    }

    public int getMaxPartyPokemon() {
        return this.maxPartyPokemon;
    }

    @Override
    public String getName(int index) {
        if (index >= this.names.size() || index < 0) {
            return this.names.get(0);
        }
        return this.names.get(index);
    }

    @Override
    public TrainerChat getChat(int index) {
        if (index >= this.chat.size() || index < 0) {
            return this.chat.get(0);
        }
        return this.chat.get(index);
    }
}

