/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class FormsPaletteStrategy
extends WikiCommandStrategy {
    public FormsPaletteStrategy() {
        super("formsandpalette", "forms", "palettes");
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public Optional<ITextComponent> getBanner(CommandSource sender, Pokemon pokemon, String[] args) {
        if (!PokemonHelper.hasPermanentFormsOrPalettes(pokemon)) {
            return Optional.empty();
        }
        return super.getBanner(sender, pokemon, args);
    }

    @Override
    public void execute(CommandSource sender, Pokemon pokemon, String[] args) {
        sender.func_197030_a((ITextComponent)new StringTextComponent(""), false);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.formsandpalette.header", PokemonHelper.getFullName(pokemon).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_PURPLE, TextFormatting.BOLD})), false);
        FormsPaletteStrategy.getUniqueFormPalettes(pokemon).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sender.func_197030_a((ITextComponent)entry.getValue(), false));
    }

    private static Map<String, ITextComponent> getUniqueFormPalettes(Pokemon pokemon) {
        HashMap<String, ITextComponent> texts = new HashMap<String, ITextComponent>();
        for (Stats form : pokemon.getSpecies().getForms()) {
            String name;
            if (FormsPaletteStrategy.shouldDisplayForm(pokemon, form) && !texts.containsKey(name = FormsPaletteStrategy.makeFormString(pokemon, form))) {
                String wiki = "/wiki " + pokemon.getSpecies().getName() + " form:" + form.getName();
                texts.put(name, FormsPaletteStrategy.makeFormPaletteText(name, wiki));
            }
            for (Gender gender : form.getPossibleGenders()) {
                for (PaletteProperties palette : form.getGenderProperties(gender).getPalettes()) {
                    String name2;
                    if (!FormsPaletteStrategy.shouldDisplayPalette(pokemon, palette) || texts.containsKey(name2 = FormsPaletteStrategy.makeFormPaletteString(pokemon, form, palette))) continue;
                    String wiki = "/wiki " + pokemon.getSpecies().getName() + " form:" + form.getName() + " palette:" + palette.getName();
                    texts.put(name2, FormsPaletteStrategy.makeFormPaletteText(name2, wiki));
                }
            }
        }
        return texts;
    }

    private static ITextComponent makeFormPaletteText(String name, String wiki) {
        return TextHelper.space(2).func_230529_a_((ITextComponent)new StringTextComponent("- ")).func_230529_a_((ITextComponent)PixelmonCommandUtils.format(name, new Object[0])).func_230529_a_((ITextComponent)TextHelper.space(1)).func_230529_a_((ITextComponent)new StringTextComponent("[").func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new TranslationTextComponent("pixelmon.command.wiki.formsandpalette.anchor").func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("pixelmon.command.wiki.formsandpalette.anchor.hover", new Object[]{name}))).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, wiki)))).func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new StringTextComponent("]").func_240699_a_(TextFormatting.AQUA)));
    }

    private static String makeFormString(Pokemon pokemon, Stats form) {
        String formName = "";
        if (FormsPaletteStrategy.shouldDisplayForm(pokemon, form) && !form.isDefault()) {
            formName = new TranslationTextComponent(form.getTranslationKey()).getString() + " ";
        }
        String palette = "";
        if (!pokemon.isDefaultPalette()) {
            palette = pokemon.getPalette().getLocalizedName() + " ";
        }
        return formName + palette + pokemon.getLocalizedName();
    }

    private static String makeFormPaletteString(Pokemon pokemon, Stats form, PaletteProperties palette) {
        String formName = "";
        if (FormsPaletteStrategy.shouldDisplayForm(pokemon, form) && !form.isDefault()) {
            formName = new TranslationTextComponent(form.getTranslationKey()).getString() + " ";
        }
        String paletteName = "";
        if (FormsPaletteStrategy.shouldDisplayPalette(pokemon, palette)) {
            paletteName = new TranslationTextComponent(palette.getTranslationKey()).getString() + " ";
        }
        return formName + paletteName + pokemon.getLocalizedName();
    }

    private static boolean shouldDisplayForm(Pokemon pokemon, Stats form) {
        return !form.isTemporary() && pokemon.getForm() != form && !form.isForm("shiny");
    }

    private static boolean shouldDisplayPalette(Pokemon pokemon, PaletteProperties palette) {
        boolean isDifferentPalette = pokemon.getPalette() != palette;
        boolean isNone = palette.getName().equalsIgnoreCase("none");
        boolean isShiny = palette.getName().equalsIgnoreCase("shiny");
        return isDifferentPalette && !isNone & !isShiny;
    }
}

