/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.econ;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GiveMoneyCommand
extends PixelCommand {
    public GiveMoneyCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "givemoney", "/givemoney [player] <money>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length == 2) {
            GameProfile target = PixelmonCommandUtils.findProfile(args[0]);
            if (target == null) {
                PixelmonCommandUtils.endCommand("argument.entity.notfound.player", args[0]);
            }
            double amount = NumberHelper.parseDouble(args[1]).orElse(0.0);
            BankAccount targetAccount = (BankAccount)((Object)PixelmonCommandUtils.require(BankAccountProxy.getBankAccount(target.getId()), "pixelmon.command.general.invalidplayer", new Object[0]));
            double beforeCurrency = targetAccount.getBalance().doubleValue();
            if (amount < 0.0) {
                targetAccount.take(Math.abs(amount));
            } else {
                targetAccount.add(amount);
            }
            double currencyDifference = (double)targetAccount.getBalance().intValue() - beforeCurrency;
            if (currencyDifference == 0.0) {
                if (amount > 0.0) {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.moneylimit", target.getName());
                } else {
                    PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.givemoney.nomoney", target.getName());
                }
            } else {
                String currencyString = Double.toString(currencyDifference);
                sender.func_197030_a((ITextComponent)new TranslationTextComponent("pixelmon.command.givemoney.notifygive", new Object[]{sender.func_197037_c(), currencyDifference, target.getName()}), true);
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.given", currencyString, target.getName());
                ServerPlayerEntity player = PixelmonCommandUtils.getEntityPlayer(target.getId());
                if (player != null && player != sender.func_197022_f()) {
                    PixelmonCommandUtils.sendMessage(player, TextFormatting.GRAY, "pixelmon.command.givemoney.received", sender.func_197019_b(), currencyString);
                }
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

