/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class SetRaidCommand
extends PixelCommand {
    public SetRaidCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "setraid", "/setraid <species> <stars> [x] [y] [z] [world]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if (args.length == 2 || args.length == 6) {
            DenEntity den;
            Stats form;
            Species species;
            if (args[0].contains(":")) {
                String[] split = args[0].split(":");
                species = PixelmonCommandUtils.require(PixelmonSpecies.fromName(split[0]).getValueUnsafe(), "argument.species.notfound", split[0]);
                form = species.getForm(split[1]);
            } else {
                species = PixelmonCommandUtils.require(PixelmonSpecies.fromName(args[0]).getValueUnsafe(), "argument.species.notfound", args[0]);
                form = null;
            }
            if (form == null) {
                form = species.getDefaultForm();
            }
            int stars = PixelmonCommandUtils.requireInt(args[1], 1, 5, "argument.raidstars.invalid", args[1]);
            if (args.length == 2) {
                ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(sender);
                den = (DenEntity)player.func_71121_q().func_217360_a(DenEntity.class, EntityPredicate.field_221016_a, null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new AxisAlignedBB(player.func_226277_ct_() - 10.0, player.func_226278_cu_() - 10.0, player.func_226281_cx_() - 10.0, player.func_226277_ct_() + 10.0, player.func_226278_cu_() + 10.0, player.func_226281_cx_() + 10.0));
            } else {
                int x = PixelmonCommandUtils.requireInt(args[2], "argument.coordinate.invalid");
                int y = PixelmonCommandUtils.requireInt(args[3], "argument.coordinate.invalid");
                int z = PixelmonCommandUtils.requireInt(args[4], "argument.coordinate.invalid");
                ServerWorld world = (ServerWorld)PixelmonCommandUtils.require(DimensionHelper.getWorld(args[5]), "argument.world.notfound", new Object[]{args[5]});
                den = (DenEntity)world.func_217360_a(DenEntity.class, EntityPredicate.field_221016_a, null, (double)x, (double)y, (double)z, new AxisAlignedBB((double)(x - 10), (double)(y - 10), (double)(z - 10), (double)(x + 10), (double)(y + 10), (double)(z + 10)));
            }
            if (den != null) {
                den.setData(new RaidData(den.func_145782_y(), stars, species, form));
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.setraid", species.getName(), stars), false);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.setraid.notify", sender.func_197037_c(), den.toString());
            } else {
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.setraid.noden", new Object[0]), false);
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompletePokemon();
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});
        }
        if (args.length == 6) {
            return PixelmonCommandUtils.tabCompleteWorld();
        }
        return Collections.emptyList();
    }
}

