/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class EvolveCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"evolve", "pevolve"});
    private static final List<String> FORCE_ARGUMENT_SUGGESTION = Lists.newArrayList((Object[])new String[]{"-f"});

    public EvolveCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokeevolve", "/pokeevolve [player] <slot> [-f]", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.invalidslot", args[1]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", player.func_200200_C_().getString());
        List<Evolution> evolutions = pokemon.getForm().getEvolutions();
        if (evolutions.isEmpty()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.evolve.nopokemon", new Object[0]);
            return;
        }
        if (pokemon.isEgg()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.evolve.egg", new Object[0]);
            return;
        }
        PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon((Entity)player);
        boolean evolved = true;
        boolean force = Arrays.stream(args).anyMatch(e -> e.equalsIgnoreCase("-f"));
        for (Evolution evolution : evolutions) {
            if (this.evoPassesAll(evolution.conditions, pixelmon, force)) {
                evolution.doEvolution(pixelmon, "Command");
                evolved = true;
                break;
            }
            evolved = false;
        }
        if (evolved) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.evolve.success", args[0]), false);
        } else {
            pokemon.retrieve("Command");
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.evolve.error", new Object[0]));
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.PARTY_SLOTS;
                }
                return FORCE_ARGUMENT_SUGGESTION;
            }
            case 3: {
                if (!hasPermissionOtherTarget) break;
                return FORCE_ARGUMENT_SUGGESTION;
            }
        }
        return super.getTabCompletions(server, sender, args, pos);
    }

    private boolean evoPassesAll(ArrayList<EvoCondition> evoConditions, PixelmonEntity pixelmon, boolean force) {
        if (force) {
            return true;
        }
        for (EvoCondition e : evoConditions) {
            if (e.passes(pixelmon)) continue;
            return false;
        }
        return true;
    }
}

