/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CompTakeCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pctake", "ctake"});

    public CompTakeCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "comptake", "/comptake <player> <box> <slot>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length < 3) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PCStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int box = PixelmonCommandUtils.requireInt(args[1], 1, PixelmonConfigProxy.getStorage().getComputerBoxes(), "pixelmon.command.box", PixelmonConfigProxy.getStorage().getComputerBoxes());
        int slot = PixelmonCommandUtils.requireInt(args[2], 1, 30, "pixelmon.command.slot", 30);
        StoragePosition storagePosition = new StoragePosition(box - 1, slot - 1);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(storagePosition), "pixelmon.command.compslot.nothing", target.func_200200_C_());
        storage.set(pokemon.getPosition(), null);
        ServerPlayerEntity senderPlayer = (ServerPlayerEntity)sender.func_197022_f();
        PixelmonCommandUtils.getComputerStorage(senderPlayer).add(pokemon);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.comptake.success", pokemon.getLocalizedName(), args[0]), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length == 2) {
            return IntStream.range(1, PixelmonConfigProxy.getStorage().getComputerBoxes()).mapToObj(String::valueOf).collect(Collectors.toList());
        }
        if (args.length == 3) {
            return IntStream.range(1, 30).mapToObj(String::valueOf).collect(Collectors.toList());
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

