/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.command.impl.Battle2;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BattleCommand
extends PixelCommand {
    public BattleCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokebattle", "/pokebattle <participant1> <participant2> [<participant3> <participant4>]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if (args.length == 2 || args.length == 3 || args.length == 4) {
            PlayerEntity source;
            int i;
            BattleRules br = new BattleRules();
            br.set(BattleRuleRegistry.BATTLE_TYPE, (Object)(args.length == 2 ? BattleType.SINGLE : BattleType.DOUBLE));
            Object[] entities = new Entity[args.length];
            for (i = 0; i < entities.length; ++i) {
                entities[i] = PixelmonCommandUtils.require(this.getParticipant(sender, args[i]), "pixelmon.command.battle2.invalid", i + 1);
            }
            if (CollectionHelper.find(Lists.newArrayList((Object[])entities), e -> e instanceof NPCTrainer) != null) {
                NPCTrainer trainer = (NPCTrainer)CollectionHelper.find(Lists.newArrayList((Object[])entities), e -> e instanceof NPCTrainer);
                if (!trainer.battleRules.isDefault()) {
                    br.importText(trainer.battleRules.exportText());
                }
            }
            for (i = 0; i < entities.length; ++i) {
                Object e2 = entities[i];
                for (int j = 0; j < entities.length; ++j) {
                    if (i == j || ((Entity)e2).field_70170_p == ((Entity)entities[j]).field_70170_p) continue;
                    PixelmonCommandUtils.endCommand("pixelmon.command.battle.dimension", new Object[0]);
                }
                int requiredPokemon = 1;
                if (e2 instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)e2;
                    for (int j = 0; j < entities.length; ++j) {
                        if (i == j || e2 != entities[j]) continue;
                        if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE) {
                            PixelmonCommandUtils.endCommand("pixelmon.command.battle2.duplicate", new Object[0]);
                            continue;
                        }
                        if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) != BattleType.DOUBLE) continue;
                        ++requiredPokemon;
                        if ((i >= 2 || j < 2) && (j >= 2 || i < 2)) continue;
                        PixelmonCommandUtils.endCommand("pixelmon.command.battle2.differing", new Object[0]);
                    }
                    if (BattleRegistry.getBattle((PlayerEntity)e2) != null) {
                        PixelmonCommandUtils.endCommand("pixelmon.command.battle.cannotchallenge", player.func_200200_C_());
                    }
                    PlayerPartyStorage j = StorageProxy.getParty(player);
                    continue;
                }
                if (!(e2 instanceof NPCTrainer)) continue;
                NPCTrainer trainer = (NPCTrainer)((Object)e2);
                if (trainer.battleController == null) continue;
                PixelmonCommandUtils.endCommand("pixelmon.command.battle.cannotchallenge", trainer.func_200200_C_());
            }
            Object object = source = sender.func_197022_f() instanceof PlayerEntity ? (PlayerEntity)sender.func_197022_f() : Arrays.stream(entities).filter(entity -> entity instanceof ServerPlayerEntity || entity instanceof NPCEntity).findFirst().get();
            if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE) {
                BattleParticipant one = this.prepareParticipant((Entity)entities[0], br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon(), (Entity)source);
                BattleParticipant two = this.prepareParticipant((Entity)entities[1], br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon(), (Entity)source);
                BattleRegistry.startBattle(new BattleParticipant[]{one}, new BattleParticipant[]{two}, br);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.battle.started", one.getDisplayName(), two.getDisplayName());
            } else if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.DOUBLE) {
                BattleParticipant[] battleParticipantArray;
                BattleParticipant[] battleParticipantArray2;
                Object four;
                Object three;
                Object two;
                Object one;
                BattleParticipant[][] teams = new BattleParticipant[2][];
                if (entities.length == 2) {
                    one = entities[0];
                    two = entities[0];
                    three = entities[1];
                    four = entities[1];
                } else if (entities.length == 3) {
                    one = entities[0];
                    two = entities[0];
                    three = entities[1];
                    four = entities[2];
                } else {
                    one = entities[0];
                    two = entities[1];
                    three = entities[2];
                    four = entities[3];
                }
                if (one == two) {
                    BattleParticipant[] battleParticipantArray3 = new BattleParticipant[1];
                    battleParticipantArray2 = battleParticipantArray3;
                    battleParticipantArray3[0] = this.prepareParticipant((Entity)one, 2, (Entity)source);
                } else {
                    BattleParticipant[] battleParticipantArray4 = new BattleParticipant[2];
                    battleParticipantArray4[0] = this.prepareParticipant((Entity)one, 1, (Entity)source);
                    battleParticipantArray2 = battleParticipantArray4;
                    battleParticipantArray4[1] = this.prepareParticipant((Entity)two, 1, (Entity)source);
                }
                teams[0] = battleParticipantArray2;
                if (three == four) {
                    BattleParticipant[] battleParticipantArray5 = new BattleParticipant[1];
                    battleParticipantArray = battleParticipantArray5;
                    battleParticipantArray5[0] = this.prepareParticipant((Entity)three, 2, (Entity)source);
                } else {
                    BattleParticipant[] battleParticipantArray6 = new BattleParticipant[2];
                    battleParticipantArray6[0] = this.prepareParticipant((Entity)three, 1, (Entity)source);
                    battleParticipantArray = battleParticipantArray6;
                    battleParticipantArray6[1] = this.prepareParticipant((Entity)four, 1, (Entity)source);
                }
                teams[1] = battleParticipantArray;
                BattleRegistry.startBattle(teams[0], teams[1], br);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.battle.started", Arrays.toString(Arrays.stream(teams[0]).map(BattleParticipant::getDisplayName).toArray()), Arrays.toString(Arrays.stream(teams[1]).map(BattleParticipant::getDisplayName).toArray()));
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    private BattleParticipant prepareParticipant(Entity e, int numPokemon, Entity source) {
        if (e instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)e;
            PlayerPartyStorage party = StorageProxy.getParty(player);
            List<Pokemon> pokemon = party.findAll(Pokemon::canBattle);
            PixelmonEntity[] pixelmons = new PixelmonEntity[numPokemon];
            for (int i = 0; i < pixelmons.length; ++i) {
                pixelmons[i] = pokemon.get(i).getOrSpawnPixelmon((Entity)player);
            }
            return new PlayerParticipant(player, pixelmons);
        }
        if (e instanceof NPCTrainer) {
            NPCTrainer trainer = (NPCTrainer)e;
            return new TrainerParticipant(trainer, numPokemon);
        }
        if (e instanceof PixelmonEntity) {
            PixelmonEntity pixelmon = (PixelmonEntity)e;
            pixelmon.aggression = Aggression.PASSIVE;
            pixelmon.func_70107_b(source.func_226277_ct_() + 2.0, Battle2.getTopEarthBlock(source.field_70170_p, (int)source.func_226277_ct_(), (int)source.func_226281_cx_()), source.func_226281_cx_());
            pixelmon.field_70170_p.func_217376_c((Entity)pixelmon);
            return new WildPixelmonParticipant(pixelmon);
        }
        return null;
    }

    private Entity getParticipant(CommandSource sender, String value) throws CommandSyntaxException {
        ServerPlayerEntity playerMP = PixelmonCommandUtils.getEntityPlayer(value);
        if (playerMP != null) {
            return playerMP;
        }
        List players = PixelmonCommandUtils.getEntitySelector(value).func_197342_d(sender);
        if (players.size() == 1) {
            return (Entity)players.get(0);
        }
        PokemonSpecification spec = PokemonSpecificationProxy.create(value);
        RegistryValue species = spec.getValue(SpeciesRequirement.class).orElse(null);
        if (species != null && species.isInitialized()) {
            Vector3d pos = sender.func_197036_d();
            PixelmonEntity pixelmon = spec.create((World)sender.func_197023_e());
            pixelmon.func_70107_b(pos.func_82615_a() + 0.5, pos.func_82617_b(), pos.func_82616_c() + 0.5);
            return pixelmon;
        }
        String langCode = sender.func_197022_f() instanceof ServerPlayerEntity ? ((ServerPlayerEntity)sender.func_197022_f()).getLanguage() : "en_US";
        Optional<NPCTrainer> trainer = NPCEntity.locateNPCServer((World)sender.func_197023_e(), value, NPCTrainer.class, langCode);
        return trainer.orElse(null);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        if (args.length <= 4) {
            List<String> list = PixelmonCommandUtils.tabCompleteUsernames();
            if (list.isEmpty()) {
                list = PixelmonCommandUtils.tabCompletePokemon();
            }
            return list;
        }
        return Collections.emptyList();
    }
}

