/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;

public enum EnumStatuePacketMode {
    SET_SPECIES,
    SetName,
    SetGrowth,
    SetLabel,
    SetTextureType,
    SetAnimation,
    SetModelStanding,
    SetAnimationFrame,
    SetForm,
    SetGender,
    SetShouldAnimate,
    SetPalette,
    SetBoundingBoxMode,
    SetCanMove;


    public static EnumStatuePacketMode getFromOrdinal(int value) {
        for (EnumStatuePacketMode m : EnumStatuePacketMode.values()) {
            if (m.ordinal() != value) continue;
            return m;
        }
        return null;
    }

    public Object chooseValueForMode(String stringValue, Boolean boolValue, Integer intValue) {
        switch (this) {
            case SetCanMove: {
                return boolValue;
            }
            case SetName: {
                return PixelmonSpecies.fromNameOrDex(stringValue).orElse(null);
            }
            case SetGrowth: {
                return EnumGrowth.getGrowthFromString(stringValue);
            }
            case SetLabel: {
                return stringValue;
            }
            case SetTextureType: {
                return stringValue;
            }
            case SetAnimation: {
                return stringValue;
            }
            case SetModelStanding: {
                return boolValue;
            }
            case SetAnimationFrame: {
                return intValue;
            }
            case SetForm: {
                return stringValue;
            }
            case SetGender: {
                return intValue;
            }
            case SetShouldAnimate: {
                return boolValue;
            }
            case SetPalette: {
                return stringValue;
            }
            case SetBoundingBoxMode: {
                return EnumBoundingBoxMode.valueOf(stringValue);
            }
            case SET_SPECIES: {
                return intValue;
            }
        }
        return null;
    }
}

