/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class StoreTutorDataPacket
extends AbstractPixelmonPacket {
    int npcId;
    List<NPCTutor.LearnableMove> learnableMoves;
    EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);

    public StoreTutorDataPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public StoreTutorDataPacket(int npcId, List<NPCTutor.LearnableMove> learnableMoves, EnumSet<BaseStatsLearnType> learnTypes) {
        super(PacketDirection.PLAY_SERVER);
        this.npcId = npcId;
        this.learnableMoves = learnableMoves;
        this.learnTypes = learnTypes;
    }

    @Override
    public void decode(PacketBuffer buf) {
        int i;
        this.npcId = buf.readInt();
        int count = buf.readInt();
        this.learnableMoves = new ArrayList<NPCTutor.LearnableMove>(count);
        for (i = 0; i < count; ++i) {
            NPCTutor.LearnableMove move = new NPCTutor.LearnableMove();
            move.decode(buf);
            this.learnableMoves.add(move);
        }
        count = buf.readInt();
        this.learnTypes.clear();
        for (i = 0; i < count; ++i) {
            BaseStatsLearnType type = BaseStatsLearnType.fromOrdinal(buf.readByte());
            if (type == null) continue;
            this.learnTypes.add(type);
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.npcId);
        buf.writeInt(this.learnableMoves.size());
        for (NPCTutor.LearnableMove learnableMove : this.learnableMoves) {
            learnableMove.encode(buf);
        }
        buf.writeInt(this.learnTypes.size());
        for (BaseStatsLearnType type : this.learnTypes) {
            buf.writeByte(type.ordinal());
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null || !NPCEditorItem.checkPermission((PlayerEntity)player)) {
            return;
        }
        Optional<NPCTutor> optional = NPCEntity.locateNPCServer(player.field_70170_p, this.npcId, NPCTutor.class);
        if (optional.isPresent()) {
            NPCTutor tutor = optional.get();
            tutor.moveList.clear();
            tutor.moveList.addAll(this.learnableMoves);
            tutor.learnTypes.clear();
            tutor.learnTypes.addAll(this.learnTypes);
        }
    }
}

