/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerSwapPacket
extends AbstractPixelmonPacket {
    private StoragePosition position1;
    private UUID pokemon1;
    private StoragePosition position2;
    private UUID pokemon2;

    public ServerSwapPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ServerSwapPacket(StoragePosition position1, Pokemon pokemon1, StoragePosition position2, Pokemon pokemon2) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position1 = position1;
        this.pokemon1 = pokemon1 == null ? null : pokemon1.getUUID();
        this.position2 = position2;
        this.pokemon2 = pokemon2 == null ? null : pokemon2.getUUID();
    }

    @Override
    public void encode(PacketBuffer buf) {
        this.position1.encode((ByteBuf)buf);
        buf.writeBoolean(this.pokemon1 != null);
        if (this.pokemon1 != null) {
            buf.writeLong(this.pokemon1.getMostSignificantBits());
            buf.writeLong(this.pokemon1.getLeastSignificantBits());
        }
        this.position2.encode((ByteBuf)buf);
        buf.writeBoolean(this.pokemon2 != null);
        if (this.pokemon2 != null) {
            buf.writeLong(this.pokemon2.getMostSignificantBits());
            buf.writeLong(this.pokemon2.getLeastSignificantBits());
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.position1 = StoragePosition.decode((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.pokemon1 = buf.func_179253_g();
        }
        this.position2 = StoragePosition.decode((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.pokemon2 = buf.func_179253_g();
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        PokemonStorage storage1 = StorageProxy.getStorage(sender, this.position1);
        PokemonStorage storage2 = StorageProxy.getStorage(sender, this.position2);
        if (storage1.validate(this.position1, this.pokemon1) && storage2.validate(this.position2, this.pokemon2)) {
            Pokemon fromPokemon = storage1.get(this.position1);
            Pokemon toPokemon = storage2.get(this.position2);
            if (fromPokemon != null) {
                fromPokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("Forced"));
            }
            if (toPokemon != null) {
                toPokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("Forced"));
            }
            storage2.transfer(storage1, this.position1, this.position2);
        } else {
            storage1.notifyListenerAll(sender, new EnumUpdateType[0]);
            storage2.notifyListenerAll(sender, new EnumUpdateType[0]);
        }
    }
}

