/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.npc.TeachMoveEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.listener.RotomListener;
import java.util.UUID;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ReplaceMovePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private String attackId;
    private int replaceIndex;
    private boolean checkEvo;

    public ReplaceMovePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ReplaceMovePacket(UUID pokemonUUID, String attackId, int replaceIndex, boolean checkEvo) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.attackId = attackId;
        this.replaceIndex = replaceIndex;
        this.checkEvo = checkEvo;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.attackId = buffer.func_218666_n();
        this.replaceIndex = buffer.readInt();
        this.checkEvo = buffer.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.func_180714_a(this.attackId);
        buffer.writeInt(this.replaceIndex);
        buffer.writeBoolean(this.checkEvo);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PlayerParticipant participant;
        ServerPlayerEntity player = context.getSender();
        BattleController bc = BattleRegistry.getBattle((PlayerEntity)player);
        PokemonLink pokemonLink = null;
        PixelmonWrapper pw = null;
        if (bc != null && (participant = bc.getPlayer((PlayerEntity)player)) != null && (pw = participant.getPokemonFromParty(this.pokemonUUID)) != null) {
            pokemonLink = new WrapperLink(pw);
        }
        if (pokemonLink == null) {
            pokemonLink = new DelegateLink(StorageProxy.getParty(player).find(this.pokemonUUID));
        }
        if (pokemonLink.getPokemon() == null) {
            return;
        }
        Attack attack = new Attack(this.attackId);
        boolean learnMove = true;
        if (attack.getMove() == null) {
            learnMove = false;
        }
        if (learnMove) {
            if (this.replaceIndex == -1) {
                learnMove = false;
            }
            if (learnMove) {
                boolean messageSent = LearnMoveController.hasCondition(player, this.pokemonUUID, attack.getActualMove());
                if (!LearnMoveController.canLearnMove(player, this.pokemonUUID, attack.getActualMove())) {
                    if (!messageSent) {
                        ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "pixelmon.npc.cantpay", new Object[0]);
                    }
                    learnMove = false;
                }
                if (learnMove && this.replaceIndex > -1) {
                    Moveset moveset = pokemonLink.getMoveset();
                    TranslationTextComponent oldMoveName = moveset.get(this.replaceIndex).getMove().getTranslatedName();
                    moveset.set(this.replaceIndex, attack);
                    TranslationTextComponent chatMessage = ChatHandler.getMessage("replacemove.replace", pokemonLink.getRealNickname(), oldMoveName, attack.getMove().getTranslatedName());
                    if (bc == null || bc.battleEnded) {
                        ChatHandler.sendChat((ICommandSource)player, chatMessage);
                    } else {
                        bc.sendToPlayer((PlayerEntity)player, chatMessage);
                    }
                    if (pw != null && bc.battleEnded) {
                        pw.writeToNBT();
                    }
                    pokemonLink.update(EnumUpdateType.Moveset);
                    if (pokemonLink.getSpecies().is(PixelmonSpecies.ROTOM)) {
                        RotomListener.replacedMove(pokemonLink, attack);
                    }
                    Pixelmon.EVENT_BUS.post((Event)new TeachMoveEvent.MoveLearnt.Post((PlayerEntity)player, pokemonLink.getPokemon(), null, attack.getMove()));
                }
            }
        }
        if (this.checkEvo) {
            if (pw != null) {
                pw.bc.checkedPokemon.add(pw.pokemon);
            } else {
                pokemonLink.getPokemon().tryEvolution();
            }
        }
    }
}

