/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.KeyEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonSendOutEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumKeyPacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.OccupiedPokeBallEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class KeyPacket
extends AbstractPixelmonPacket {
    private static long lastThrownTime = -1L;
    private int selectedPixelmon;
    private int entityID;
    private int moveIndex;
    private int x;
    private int y;
    private int z;
    private int side;
    private EnumKeyPacketMode mode;

    public KeyPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public KeyPacket(int selectedPixelmon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.mode = EnumKeyPacketMode.SendPokemon;
    }

    public KeyPacket(int selectedPixelmon, int entityId, EnumKeyPacketMode mode) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.entityID = entityId;
        this.mode = mode;
    }

    public KeyPacket(int selectedPixelmon, int moveIndex, int entityId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = moveIndex;
        this.entityID = entityId;
        this.mode = EnumKeyPacketMode.ExternalMoveEntity;
    }

    public KeyPacket(int selectedPixelmon, String moveName, int entityId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = this.moveIndex;
        this.entityID = entityId;
        this.mode = EnumKeyPacketMode.ExternalMoveEntity;
    }

    public KeyPacket(int selectedPixelmon, int moveIndex, BlockPos pos, Direction side) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = moveIndex;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.mode = EnumKeyPacketMode.ExternalMoveBlock;
        this.side = side.func_176745_a();
    }

    public KeyPacket(int selectedPixelmon, String moveName, BlockPos pos, Direction side) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveIndex = this.moveIndex;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.mode = EnumKeyPacketMode.ExternalMoveBlock;
        this.side = side.func_176745_a();
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.mode = EnumKeyPacketMode.getFromOrdinal(buffer.readByte());
        this.selectedPixelmon = buffer.readByte();
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                this.entityID = buffer.readInt();
                break;
            }
            case ExternalMoveEntity: {
                this.entityID = buffer.readInt();
                this.moveIndex = buffer.readInt();
                break;
            }
            case ExternalMoveBlock: {
                this.moveIndex = buffer.readInt();
                this.x = buffer.readInt();
                this.y = buffer.readInt();
                this.z = buffer.readInt();
                this.side = buffer.readInt();
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeByte(this.mode.ordinal());
        buffer.writeByte(this.selectedPixelmon);
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                buffer.writeInt(this.entityID);
                break;
            }
            case ExternalMoveEntity: {
                buffer.writeInt(this.entityID);
                buffer.writeInt(this.moveIndex);
                break;
            }
            case ExternalMoveBlock: {
                buffer.writeInt(this.moveIndex);
                buffer.writeInt(this.x);
                buffer.writeInt(this.y);
                buffer.writeInt(this.z);
                buffer.writeInt(this.side);
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        EnumKeyPacketMode mode = this.mode;
        KeyEvent event = new KeyEvent(context.getSender(), mode);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (mode == EnumKeyPacketMode.SendPokemon) {
            this.sendPokemon(context);
            return;
        }
        World world = context.getSender().field_70170_p;
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getParty(player);
        Pokemon pokemon = storage.get(this.selectedPixelmon);
        if (player.func_175149_v()) {
            ChatHandler.sendChat((Entity)player, "sendpixelmon.isspectator", new Object[0]);
            return;
        }
        if (pokemon == null || pokemon.getPixelmonEntity() == null) {
            return;
        }
        PixelmonEntity pixelmon = pokemon.getPixelmonEntity().orElse(null);
        if (pixelmon != null) {
            if (mode == EnumKeyPacketMode.ActionKeyEntity) {
                LivingEntity entity = (LivingEntity)world.func_73045_a(this.entityID);
                pixelmon.func_70624_b(entity);
            }
            if (mode.isAction()) {
                pixelmon.update(EnumUpdateType.Target);
            }
        }
    }

    private void sendPokemon(NetworkEvent.Context context) {
        if (!Pixelmon.canSendOutPokemon) {
            return;
        }
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getParty(player);
        Pokemon pokemon = storage.get(this.selectedPixelmon);
        if (pokemon == null || pokemon.isEgg()) {
            return;
        }
        String nickname = pokemon.getDisplayName();
        if (pokemon.isFainted()) {
            ChatHandler.sendChat((Entity)player, "sendpixelmon.cantbattle", new TranslationTextComponent(nickname));
        } else if (pokemon.getPixelmonEntity().isPresent()) {
            PixelmonEntity pixelmon = pokemon.getPixelmonEntity().orElse(null);
            if (pixelmon.func_184179_bs() == player) {
                player.func_233575_bb_();
            }
            if (pixelmon.getOwner() == null) {
                pixelmon.unloadEntity();
            } else if (pixelmon.getOwner() == player) {
                pixelmon.retrieve("PlayerActivated");
                ChatHandler.sendChat((Entity)player, "sendpixelmon.retrieved", new TranslationTextComponent(nickname));
            }
        } else {
            if (Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Pre(player, pokemon))) {
                return;
            }
            long worldTime = player.field_70170_p.func_72820_D();
            if (lastThrownTime - worldTime < 300L && storage.transientData.thrownPokeball != null && storage.transientData.thrownPokeball.func_70089_S()) {
                return;
            }
            PokeBall caughtBall = pokemon.getBall();
            storage.transientData.thrownPokeball = new OccupiedPokeBallEntity(player.field_70170_p, (LivingEntity)player, this.selectedPixelmon, caughtBall);
            if (player.field_70170_p.func_217376_c((Entity)storage.transientData.thrownPokeball)) {
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)SoundRegistration.POKEBALL_THROW.get(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                ChatHandler.sendChat((Entity)player, "sendpixelmon.sentout", new TranslationTextComponent(nickname));
                lastThrownTime = worldTime;
            } else {
                storage.transientData.thrownPokeball = null;
            }
        }
    }
}

