/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.FossilCleanerTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.items.CoveredFossilItem;
import com.pixelmonmod.pixelmon.items.FossilItem;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityFossilCleaner
extends TileEntityRenderer<FossilCleanerTileEntity> {
    private static final ResourceLocation texture = ResourceLocationHelper.of("pixelmon", "textures/block/fossilcleaner.png");
    private static final GenericModelHolder<GenericSmdModel> fossilCleaner = new GenericModelHolder("blocks/fossil_cleaner/fossil_cleaner.pqc");
    private static final GenericModelHolder<GenericSmdModel> fossilCleanerArm = new GenericModelHolder("blocks/fossil_cleaner/fossil_cleaner_arm.pqc");
    private static final GenericSmdModel fossilCleanerGlass = new GenericSmdModel("models/blocks/fossil_cleaner", "fossil_cleaner_glass.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredHelixFossil = new GenericModelHolder("fossils/covered/covered_helix.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredDomeFossil = new GenericModelHolder("fossils/covered/covered_dome.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredOldAmber = new GenericModelHolder("fossils/covered/covered_oldamber.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredClawFossil = new GenericModelHolder("fossils/covered/covered_claw.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredSkullFossil = new GenericModelHolder("fossils/covered/covered_skull.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredArmorFossil = new GenericModelHolder("fossils/covered/covered_armor.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredCoverFossil = new GenericModelHolder("fossils/covered/covered_cover.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredPlumeFossil = new GenericModelHolder("fossils/covered/covered_plume.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredJawFossil = new GenericModelHolder("fossils/covered/covered_jaw.pqc");
    private static final GenericModelHolder<GenericSmdModel> coveredSailFossil = new GenericModelHolder("fossils/covered/covered_sail.pqc");

    public RenderTileEntityFossilCleaner(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.correctionAngles = 180;
        RenderTileEntityFossilCleaner.fossilCleanerGlass.modelRenderer.setTransparent(0.5f);
    }

    @Override
    public void render(FossilCleanerTileEntity cleaner, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        this.renderTransparentSMD(matrix, buffer, fossilCleanerGlass.getModel(), texture, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        int frame = cleaner.timer >= 360 ? 0 : cleaner.timer * 2;
        ((GenericSmdModel)((Object)fossilCleaner.getModel())).setFrame(frame);
        this.renderSMD(matrix, buffer, (Model)fossilCleaner.getModel(), texture, combinedLight, combinedOverlay);
        ((GenericSmdModel)((Object)fossilCleanerArm.getModel())).setFrame(frame);
        this.renderSMD(matrix, buffer, (Model)fossilCleanerArm.getModel(), texture, combinedLight, combinedOverlay);
        Item itemInside = cleaner.getItemInCleaner();
        if (itemInside != null) {
            GenericModelHolder fossilModel = null;
            ResourceLocation resourceLocation = null;
            if (itemInside instanceof CoveredFossilItem) {
                CoveredFossilItem coveredFossil = (CoveredFossilItem)itemInside;
                switch (coveredFossil.getFossil()) {
                    case HELIX: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png");
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    case DOME: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_dome_fossilmodel.png");
                        fossilModel = coveredDomeFossil;
                        break;
                    }
                    case OLD_AMBER: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_old_amber_fossilmodel.png");
                        fossilModel = coveredOldAmber;
                        break;
                    }
                    case ROOT: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png");
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    case CLAW: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_claw_fossilmodel.png");
                        fossilModel = coveredClawFossil;
                        break;
                    }
                    case SKULL: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_skull_fossilmodel.png");
                        fossilModel = coveredSkullFossil;
                        break;
                    }
                    case ARMOR: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_armor_fossilmodel.png");
                        fossilModel = coveredArmorFossil;
                        break;
                    }
                    case COVER: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_cover_fossilmodel.png");
                        fossilModel = coveredCoverFossil;
                        break;
                    }
                    case PLUME: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_plume_fossilmodel.png");
                        fossilModel = coveredPlumeFossil;
                        break;
                    }
                    case JAW: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_jaw_fossilmodel.png");
                        fossilModel = coveredJawFossil;
                        break;
                    }
                    case SAIL: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_sail_fossilmodel.png");
                        fossilModel = coveredSailFossil;
                        break;
                    }
                    case BIRD: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png");
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    case DINO: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png");
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    case DRAKE: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png");
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    case FISH: {
                        resourceLocation = ResourceLocationHelper.of("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png");
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    default: {
                        Pixelmon.LOGGER.warn("Unknown covered Fossil present. Name: " + coveredFossil.toString());
                        break;
                    }
                }
            } else if (itemInside instanceof FossilItem) {
                FossilItem fossil = (FossilItem)itemInside;
                resourceLocation = fossil.getFossil().getTexture();
                fossilModel = (GenericModelHolder)fossil.getFossil().getModel();
            } else {
                Pixelmon.LOGGER.warn("Unrecognised item type in Fossil cleaner: " + itemInside.func_77658_a());
            }
            if (fossilModel != null) {
                if (itemInside instanceof CoveredFossilItem) {
                    ((GenericSmdModel)((Object)fossilModel.getModel())).setFrame(frame);
                } else {
                    matrix.func_227861_a_(0.0, -0.555, 0.0);
                }
                this.renderSMD(matrix, buffer, (Model)fossilModel.getModel(), resourceLocation, combinedLight, combinedOverlay);
            }
        }
    }
}

