/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.machines.AnvilBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.AnvilTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelAnvil;
import com.pixelmonmod.pixelmon.client.models.plates.ModelIngot;
import com.pixelmonmod.pixelmon.client.models.plates.ModelPlate;
import com.pixelmonmod.pixelmon.client.models.plates.ModelPlateStage2;
import com.pixelmonmod.pixelmon.client.models.plates.ModelPlateStage3;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityAnvil
extends TileEntityRenderer<AnvilTileEntity> {
    private static final ResourceLocation ANVIL_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/block/anvil.png");
    private static final ResourceLocation ALUMINIUM_INGOT_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/block/aluminium/ingot.png");
    private static final GenericModelHolder<ModelAnvil> MODEL = new GenericModelHolder<ModelAnvil>(ModelAnvil.class);
    private static final GenericModelHolder<ModelIngot> MODEL_PLATE_INGOT = new GenericModelHolder<ModelIngot>(ModelIngot.class);
    private static final GenericModelHolder<ModelPlate> MODEL_PLATE = new GenericModelHolder<ModelPlate>(ModelPlate.class);
    private static final GenericModelHolder<ModelPlateStage2> MODEL_PLATE_STAGE_2 = new GenericModelHolder<ModelPlateStage2>(ModelPlateStage2.class);
    private static final GenericModelHolder<ModelPlateStage3> MODEL_PLATE_STAGE_3 = new GenericModelHolder<ModelPlateStage3>(ModelPlateStage3.class);

    public RenderTileEntityAnvil(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.yOffset = 1.5f;
        this.correctionAngles = 90;
    }

    @Override
    public void render(AnvilTileEntity anvil, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrix.func_227863_a_(QuaternionHelper.fromEuler(-90.0f, 0.0f, 1.0f, 0.0f));
        this.renderModel(matrix, buffer, (Model)MODEL.getModel(), ANVIL_TEXTURE, combinedLight, combinedOverlay);
        if (!anvil.getStack().func_190926_b()) {
            Item item = anvil.getStack().func_77973_b();
            if (item == PixelmonItems.aluminium_ingot.getItem()) {
                if (anvil.getState() == 0) {
                    this.renderModel(matrix, buffer, (Model)MODEL_PLATE_INGOT.getModel(), ALUMINIUM_INGOT_TEXTURE, combinedLight, combinedOverlay);
                } else if (anvil.getState() == 1) {
                    this.renderModel(matrix, buffer, (Model)MODEL_PLATE_STAGE_2.getModel(), ALUMINIUM_INGOT_TEXTURE, combinedLight, combinedOverlay);
                } else if (anvil.getState() == 2) {
                    this.renderModel(matrix, buffer, (Model)MODEL_PLATE_STAGE_3.getModel(), ALUMINIUM_INGOT_TEXTURE, combinedLight, combinedOverlay);
                }
            } else if (item == PixelmonItems.aluminium_plate.getItem()) {
                this.renderModel(matrix, buffer, (Model)MODEL_PLATE.getModel(), ALUMINIUM_INGOT_TEXTURE, combinedLight, combinedOverlay);
            }
        }
    }

    @Override
    protected int getRotation(BlockState state) {
        if (state.func_177230_c() instanceof AnvilBlock) {
            Direction facing = (Direction)state.func_177229_b((Property)AnvilBlock.FACING);
            if (facing == Direction.EAST) {
                return 270;
            }
            if (facing == Direction.NORTH) {
                return 0;
            }
            if (facing == Direction.WEST) {
                return 90;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
        }
        return 0;
    }
}

