/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.particles.Electric;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class DynamaxRenderer {
    private static final float[] RED = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] BLUE = new float[]{0.0f, 0.35f, 1.0f, 1.0f};

    public static void dynamaxRender(AbstractClientEntity entity, MatrixStack matrix, IRenderTypeBuffer buffer, ResourceLocation tex, Model model, float partialTicks, int packedLight, int packedOverlay) {
        float[] color;
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDCulledRenderType(tex));
        boolean calyrex = entity.getSpecies().is(PixelmonSpecies.CALYREX);
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        scaleFactor *= entity.getScaleFactor() / 1.3f;
        if (entity.getSpecies().is(PixelmonSpecies.ORBEETLE)) {
            scaleFactor /= 1.5f;
        }
        Dimensions dimensions = entity.getPokemon().getForm().getDimensions();
        if (entity.transformed != null) {
            dimensions = entity.transformed.getSpecies().getDefaultForm().getDimensions();
        }
        double targetMetric = Math.max(dimensions.getHeight(), dimensions.getWidth());
        float dynamaxScale = entity.getDynamaxScale();
        if (dynamaxScale > 0.0f) {
            double targetHeight = PixelmonConfigProxy.getGeneral().getDynamaxSize();
            double currentHeight = targetMetric * (double)entity.getPixelmonScale();
            if (currentHeight < targetHeight) {
                double scaling = targetHeight / currentHeight;
                scaleFactor = (float)((double)scaleFactor * Math.max((double)dynamaxScale * scaling, (double)entity.getPixelmonScale()));
            } else {
                scaleFactor *= entity.getPixelmonScale();
            }
        } else {
            scaleFactor *= entity.getPixelmonScale();
        }
        matrix.func_227860_a_();
        matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
        float theta = Minecraft.func_71410_x().field_71441_e.func_82737_E() % 360L;
        matrix.func_227863_a_(QuaternionHelper.fromEuler(-MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70126_B, (float)entity.field_70177_z), 0.0f, 0.0f, 1.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(theta, 0.0f, 0.0f, 1.0f));
        matrix.func_227861_a_(0.0, 0.0, (double)-1.15f);
        matrix.func_227862_a_(0.25f, 0.25f, 0.25f);
        float[] fArray = color = calyrex ? BLUE : RED;
        if (model instanceof ValveStudioModel) {
            ((ValveStudioModel)model).animate();
        }
        model.func_225598_a_(matrix, vertices, 0xF000F0, packedOverlay, color[0], color[1], color[2], color[3]);
        matrix.func_227865_b_();
        if (RandomHelper.rand.nextInt(35) == 0) {
            ClientWorld w = Minecraft.func_71410_x().field_71441_e;
            ParticleArcanery parent = new ParticleArcanery(entity.func_226277_ct_() + w.field_73012_v.nextDouble() * 1.5 - 0.75, entity.func_226278_cu_() + targetMetric * (double)scaleFactor - 3.0, entity.func_226281_cx_() + w.field_73012_v.nextDouble() * 1.5 - 0.75, 0.0, -1.0, 0.0, new Electric(20 + w.field_73012_v.nextInt(6), true, 90.0f, w.field_73012_v.nextFloat() * 360.0f, 0.4f, 0.2f, calyrex ? 0.0f : 1.0f, calyrex ? 0.1f : 0.0f, calyrex ? 1.0f : 0.0f));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)parent);
        }
    }
}

