/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.items.SpriteItemModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.layers.PokemonShimLayer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LensInfoPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public abstract class AbstractPokemonRenderer<E extends AbstractClientEntity>
extends MobRenderer<E, PixelmonModelBase<E>> {
    private static final int DEFAULT_NAME_RENDER_DISTANCE = 8;
    private static final int DEFAULT_BOSS_NAME_RENDER_DISTANCE_EXTENSION = 8;
    private final int configNameRenderMultiplier = Math.max(1, Math.min(PixelmonConfigProxy.getGraphics().getNamePlateRange(), 3));
    private final int nameRenderDistanceNormal = 8 * this.configNameRenderMultiplier;
    private final int nameRenderDistanceBoss = this.nameRenderDistanceNormal + 8;
    public float distance = 0.0f;
    protected String lvlTag;
    protected String bossTag;

    public AbstractPokemonRenderer(EntityRendererManager manager) {
        super(manager, null, 0.5f);
        PokemonShimLayer shim = new PokemonShimLayer(this);
        this.field_77045_g = shim.getParentModel();
        this.func_177094_a(shim);
    }

    protected boolean shouldShowName(E entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(E entity) {
        if (((AbstractBaseEntity)((Object)entity)).isPalette("online") && ((AbstractBaseEntity)((Object)entity)).func_184780_dh() != null) {
            PlayerExtraDataStore.get(((AbstractBaseEntity)((Object)entity)).func_184780_dh()).checkPokemon(((AbstractClientEntity)entity).getPokemon());
        }
        return ((AbstractClientEntity)entity).getTexture();
    }

    public void scale(E entity, MatrixStack matrix, float partialTicks) {
        this.preRenderScale((AbstractClientEntity)entity, matrix, partialTicks);
    }

    public void render(E entityIn, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        boolean shouldSit;
        if (((AbstractClientEntity)entityIn).isSpriteModel() || PixelmonConfigProxy.getGraphics().isGlobalSpriteToggle() || !this.doesModelExist(((AbstractClientEntity)entityIn).getModel())) {
            StatueEntity statue;
            IBakedModel ibakedmodel = SpriteItemModel.getBakedModel(((AbstractClientEntity)entityIn).getPokemon(), Minecraft.func_71410_x().func_175599_af().func_175037_a().func_199312_b((Item)PixelmonItems.pixelmon_sprite));
            if (ibakedmodel == null) {
                return;
            }
            this.renderNameTag(entityIn, StringTextComponent.field_240750_d_, matrix, buffer, packedLight);
            float[] renderColor = ((AbstractClientEntity)entityIn).getRenderColor();
            if (entityIn instanceof StatueEntity && (statue = (StatueEntity)entityIn).getColor() != Color.WHITE && statue.getColor() != null) {
                renderColor = new float[]{(float)statue.getColor().getRed() / 255.0f, (float)statue.getColor().getGreen() / 255.0f, (float)statue.getColor().getBlue() / 255.0f, 1.0f};
            }
            if (((AbstractBaseEntity)((Object)entityIn)).getBossTier().isBoss()) {
                renderColor = ((AbstractBaseEntity)((Object)entityIn)).getBossTier().getColor().getColorComponents(null);
            }
            matrix.func_227860_a_();
            matrix.func_227863_a_(this.field_76990_c.field_217783_c.func_227995_f_());
            matrix.func_227862_a_(6.0f, 6.0f, 6.0f);
            matrix.func_227862_a_(Math.min((float)((AbstractClientEntity)entityIn).getPokemon().getForm().getDimensions().getHeight(), 1.0f), Math.min((float)((AbstractClientEntity)entityIn).getPokemon().getForm().getDimensions().getHeight(), 1.0f), Math.min((float)((AbstractClientEntity)entityIn).getPokemon().getForm().getDimensions().getHeight(), 1.0f));
            matrix.func_227861_a_((double)(-entityIn.func_213311_cf()), 0.0, (double)(-entityIn.func_213311_cf()));
            PixelmonRendering.renderQuadList(matrix.func_227866_c_(), buffer.getBuffer(Atlases.func_239280_i_()), renderColor[0], renderColor[1], renderColor[2], ibakedmodel.getQuads(null, null, RandomHelper.getRandom(), (IModelData)EmptyModelData.INSTANCE), packedLight, LivingRenderer.func_229117_c_(entityIn, (float)0.0f));
            matrix.func_227865_b_();
            return;
        }
        this.field_76987_f = !((AbstractBaseEntity)((Object)entityIn)).isOverlay() && ((AbstractBaseEntity)((Object)entityIn)).getColor() != null ? (float)((AbstractBaseEntity)((Object)entityIn)).getColor().getAlpha() / 255.0f : 1.0f;
        if (((AbstractBaseEntity)((Object)entityIn)).isDisableShadow()) {
            this.field_76989_e = 0.0f;
            this.field_76987_f = 0.0f;
        } else {
            this.field_76989_e = (float)(((AbstractClientEntity)entityIn).getPokemon().getForm().getDimensions().getWidth() / 2.0);
        }
        if (((AbstractClientEntity)entityIn).isEvolving()) {
            this.field_76987_f = 0.0f;
        }
        this.field_77045_g = (PixelmonModelBase)((AbstractClientEntity)entityIn).getModel();
        if (Minecraft.func_71410_x().field_175622_Z != null) {
            this.distance = entityIn.func_70032_d(Minecraft.func_71410_x().field_175622_Z);
        }
        ((PokemonShimLayer)((Object)this.field_177097_h.get(0))).setModel((PixelmonModelBase)this.field_77045_g);
        if (this.field_77045_g == null) {
            return;
        }
        matrix.func_227860_a_();
        this.renderNameTag(entityIn, null, matrix, buffer, packedLight);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        ((PixelmonModelBase)this.field_77045_g).field_217112_c = this.func_77040_d((LivingEntity)entityIn, partialTicks);
        ((PixelmonModelBase)this.field_77045_g).field_217113_d = shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
        ((PixelmonModelBase)this.field_77045_g).field_217114_e = entityIn.func_70631_g_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)((AbstractClientEntity)entityIn).field_70760_ar, (float)((AbstractClientEntity)entityIn).field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)((AbstractClientEntity)entityIn).field_70758_at, (float)((AbstractClientEntity)entityIn).field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)((AbstractClientEntity)entityIn).field_70127_C, (float)((AbstractClientEntity)entityIn).field_70125_A);
        float f7 = this.func_77044_a((LivingEntity)entityIn, partialTicks);
        this.func_225621_a_((LivingEntity)entityIn, matrix, f7, f, partialTicks);
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.scale(entityIn, matrix, partialTicks);
        matrix.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)((AbstractClientEntity)entityIn).field_184618_aE, (float)((AbstractClientEntity)entityIn).field_70721_aZ);
            f5 = ((AbstractClientEntity)entityIn).field_184619_aG - ((AbstractClientEntity)entityIn).field_70721_aZ * (1.0f - partialTicks);
            if (entityIn.func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((PixelmonModelBase)this.field_77045_g).func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        ((PixelmonModelBase)this.field_77045_g).func_225597_a_((Entity)entityIn, f5, f8, f7, f2, f6);
        ((LayerRenderer)this.field_177097_h.get(0)).func_225628_a_(matrix, buffer, packedLight, entityIn, f5, f8, partialTicks, f7, f2, f6);
        matrix.func_227865_b_();
    }

    protected void renderLabel(E entity, MatrixStack matrix, IRenderTypeBuffer buffer, int light, boolean owned) {
        PixelmonEntity pixelmon;
        LensInfoPacket info;
        ITextComponent line2;
        String line1;
        matrix.func_227860_a_();
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = ((AbstractBaseEntity)((Object)entity)).getPixelmonScale() * scaleFactor * ((AbstractClientEntity)entity).getScaleFactor();
        Dimensions dimensions = ((AbstractClientEntity)entity).getPokemon().getForm().getDimensions();
        double height = 0.7 + dimensions.getHeight() * (double)scale;
        matrix.func_227861_a_(0.0, height, 0.0);
        matrix.func_227863_a_(this.field_76990_c.func_229098_b_());
        matrix.func_227862_a_(-0.025f, -0.025f, 0.025f);
        String line3 = null;
        int color1 = -1;
        int color2 = -1;
        int pokemonLevel = ((AbstractClientEntity)entity).getPokemon().getPokemonLevel();
        if (owned) {
            if (((AbstractClientEntity)entity).getPokemon().isShiny()) {
                color2 = -15000;
            }
            line1 = Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString();
            line2 = ((AbstractClientEntity)entity).getPokemon().getDisplayNameWithRibbon();
            line3 = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemonLevel;
        } else if (((AbstractBaseEntity)((Object)entity)).func_184780_dh() != null) {
            PlayerEntity player;
            if (((AbstractClientEntity)entity).getPokemon().isShiny()) {
                color2 = -15000;
            }
            line1 = (player = entity.func_130014_f_().func_217371_b(((AbstractBaseEntity)((Object)entity)).func_184780_dh())) == null ? "Unknown" : player.func_200200_C_().getString();
            line2 = ((AbstractClientEntity)entity).getPokemon().getDisplayNameWithRibbon();
            line3 = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemonLevel;
        } else {
            BossTier bossTier = ((AbstractBaseEntity)((Object)entity)).getBossTier();
            if (bossTier.isNotBoss()) {
                if (PixelmonServerConfig.renderWildLevels) {
                    if (this.lvlTag == null) {
                        this.lvlTag = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]);
                    }
                    line1 = this.lvlTag;
                    line2 = new StringTextComponent(String.valueOf(pokemonLevel));
                } else {
                    line1 = "";
                    line2 = StringTextComponent.field_240750_d_;
                }
                if (((AbstractClientEntity)entity).getPokemon().isShiny()) {
                    int colour;
                    color1 = color2 = (colour = -15000);
                }
            } else {
                if (this.bossTag == null) {
                    this.bossTag = I18n.func_135052_a((String)"gui.boss.text", (Object[])new Object[0]);
                }
                line1 = this.bossTag;
                line2 = new TranslationTextComponent(bossTier.getName());
                int color = bossTier.getColor().getRGB();
                if (PixelmonConfigProxy.getGraphics().isShowWildNames()) {
                    color1 = color;
                } else {
                    color2 = color;
                }
            }
            if (PixelmonConfigProxy.getGraphics().isShowWildNames()) {
                line1 = line1 + " " + line2.getString();
                line2 = ((AbstractClientEntity)entity).getPokemon().getDisplayNameWithRibbon();
            }
        }
        FontRenderer fontrenderer = this.func_76983_a();
        int line2Width = fontrenderer.func_238414_a_((ITextProperties)line2);
        int line2Pos = line2Width / 2 * -1;
        int j = 0;
        if (((AbstractBaseEntity)((Object)entity)).getPalette().usingFallback()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)(-line2Width), -14.0, 0.0);
            fontrenderer.func_228079_a_(I18n.func_135052_a((String)"pixelmon.fallback.warning", (Object[])new Object[0]), 0.0f, 0.0f, Color.RED.getRGB(), false, matrix.func_227866_c_().func_227870_a_(), buffer, false, j, light);
            matrix.func_227865_b_();
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(-2.5 + (double)line2Pos, -4.5, 0.0);
        matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        fontrenderer.func_228079_a_(line1, 0.0f, 0.0f, color1, false, matrix4f, buffer, false, j, light);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 2.5, 0.0);
        matrix4f = matrix.func_227866_c_().func_227870_a_();
        fontrenderer.func_243247_a(line2, (float)(-line2Width) / 2.0f, 0.0f, color2, false, matrix4f, buffer, false, j, light);
        matrix.func_227865_b_();
        if (line3 != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(2.5 + (double)line2Pos, 13.0, 0.0);
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            fontrenderer.func_228079_a_(line3, 0.0f, 0.0f, color1, false, matrix.func_227866_c_().func_227870_a_(), buffer, false, j, light);
            matrix.func_227865_b_();
        }
        List<String> flags = ((AbstractClientEntity)entity).getPokemon().getFlags();
        int positionCounter = 0;
        for (String flag : flags) {
            matrix.func_227860_a_();
            double d = (line3 != null ? 5.0 : 2.5) + (double)line2Pos;
            int n = line3 != null ? 20 : 13;
            this.func_76983_a().getClass();
            matrix.func_227861_a_(d, (double)(n + positionCounter * 9), 0.0);
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            fontrenderer.func_228079_a_(I18n.func_135052_a((String)("pixelmon.flag." + flag.toLowerCase(Locale.ROOT)), (Object[])new Object[0]), 0.0f, 0.0f, color1, false, matrix.func_227866_c_().func_227870_a_(), buffer, false, j, light);
            matrix.func_227865_b_();
            ++positionCounter;
        }
        if (entity instanceof PixelmonEntity && (info = (pixelmon = (PixelmonEntity)entity).getClientOnlyInfo()) != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(30.0, -4.5, 0.0);
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
            fontrenderer.func_243247_a((ITextComponent)new TranslationTextComponent("gui.screenpokechecker.ability").func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(info.abilityLangKey)), 0.0f, 0.0f, -1, false, mat, buffer, false, j, light);
            fontrenderer.func_243247_a((ITextComponent)new TranslationTextComponent("gui.screenpokechecker.nature").func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(info.nature.getTranslationKey())), 0.0f, 10.0f, -1, false, mat, buffer, false, j, light);
            fontrenderer.func_243247_a((ITextComponent)new TranslationTextComponent("gui.trainereditor.ivs").func_240702_b_(": (" + info.ivs.getPercentageString(0) + "%) " + info.ivs.getShorthand("/")), 0.0f, 20.0f, -1, false, mat, buffer, false, j, light);
            if (pixelmon.getPokemon().getGender() != Gender.NONE) {
                fontrenderer.func_243247_a((ITextComponent)new TranslationTextComponent("gui.trainereditor.gender").func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(pixelmon.getPokemon().getGender().getTranslationKey())), 0.0f, 30.0f, -1, false, mat, buffer, false, j, light);
            }
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    protected void preRenderScale(AbstractClientEntity entity, MatrixStack matrix, float partialTicks) {
        double lScale;
        double hScale;
        double wScale;
        float dynamaxScale;
        PixelmonModelBase model;
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        scaleFactor *= entity.getScaleFactor();
        if (entity.getModel() instanceof PixelmonModelBase && (model = (PixelmonModelBase)entity.getModel()) instanceof PixelmonModelSmd && ((PixelmonModelSmd)model).theModel != null) {
            scaleFactor *= model.getScale();
        }
        Dimensions dimensions = entity.getForm().getDimensions();
        if (entity.transformed != null) {
            dimensions = entity.transformed.getSpecies().getDefaultForm().getDimensions();
        }
        if ((dynamaxScale = entity.getDynamaxScale()) > 0.0f) {
            double targetMetric = Math.max(dimensions.getHeight(), dimensions.getWidth());
            float targetHeight = PixelmonConfigProxy.getGeneral().getDynamaxSize() / 2.0f;
            double currentHeight = targetMetric * (double)entity.getPixelmonScale();
            if (currentHeight < (double)targetHeight) {
                double scaling = (double)targetHeight / currentHeight;
                scaleFactor = (float)((double)scaleFactor * Math.max((double)dynamaxScale * scaling, (double)entity.getPixelmonScale()));
            } else {
                scaleFactor *= entity.getPixelmonScale();
            }
        } else {
            scaleFactor *= entity.getPixelmonScale();
        }
        matrix.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        if (entity.getEvoStage() == EvolutionStage.PreAnimation) {
            float scale = (float)entity.evoAnimTicks / ((float)EvolutionStage.PreAnimation.ticks + (float)EvolutionStage.PostAnimation.ticks);
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            wScale = (double)(scale * entity.widthDiff) / dimensions.getWidth();
            hScale = (double)(scale * entity.heightDiff) / dimensions.getHeight();
            lScale = (double)(scale * entity.lengthDiff) / dimensions.getWidth();
            matrix.func_227862_a_((float)(1.0 + wScale), (float)(1.0 + hScale), (float)(1.0 + lScale));
        }
        if (entity.getEvoStage() == EvolutionStage.PostAnimation) {
            float scale = ((float)entity.evoAnimTicks + (float)EvolutionStage.PreAnimation.ticks) / ((float)EvolutionStage.PreAnimation.ticks + (float)EvolutionStage.PostAnimation.ticks);
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            scale = 1.0f - scale;
            wScale = (double)(scale * entity.widthDiff) / dimensions.getWidth();
            hScale = (double)(scale * entity.heightDiff) / dimensions.getHeight();
            lScale = (double)(scale * entity.lengthDiff) / dimensions.getWidth();
            matrix.func_227862_a_((float)(1.0 - wScale), (float)(1.0 - hScale), (float)(1.0 - lScale));
        }
        ((PixelmonModelBase)this.field_77045_g).scale = scaleFactor;
    }

    private boolean doesModelExist(Model model) {
        if (model == null) {
            return false;
        }
        if (!(model instanceof PixelmonModelBase)) {
            return true;
        }
        PixelmonModelBase modelBase = (PixelmonModelBase)model;
        if (!(modelBase instanceof PixelmonModelSmd)) {
            return true;
        }
        return ((PixelmonModelSmd)modelBase).theModel != null;
    }

    public void renderNameTag(E entity, ITextComponent name, MatrixStack matrix, IRenderTypeBuffer buffer, int light) {
        float renderDistance;
        if (((AbstractBaseEntity)((Object)entity)).isDisableNametag() || ((AbstractClientEntity)entity).getPokemon() == null || !Minecraft.func_71382_s() || entity.func_225608_bj_() || entity.func_184179_bs() == Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        boolean owned = ((AbstractClientEntity)entity).getPokemon().getOwnerPlayerUUID() == Minecraft.func_71410_x().field_71439_g.func_110124_au();
        float f = renderDistance = ((AbstractBaseEntity)((Object)entity)).getBossTier().isBoss() ? (float)this.nameRenderDistanceBoss : (float)this.nameRenderDistanceNormal;
        if (this.distance <= renderDistance || owned) {
            this.renderLabel(entity, matrix, buffer, light, owned);
        }
    }
}

