/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SlingRing
extends ParticleEffect {
    private final boolean parent;
    private final int maxAge;
    private static final ResourceLocation tex = ResourceLocationHelper.of("pixelmon", "textures/particle/sling_ring.png");

    public SlingRing(boolean parent, int maxAge) {
        this.parent = parent;
        this.maxAge = maxAge;
    }

    @Override
    public void init(ParticleArcanery particle, World world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f, 1.0f, 1.0f, this.parent ? 0.0f : 0.5f);
        particle.setSize(0.75f);
        particle.func_187114_a(this.maxAge);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        particle.incrementAge();
        if (particle.getAge() >= particle.func_206254_h()) {
            particle.func_187112_i();
        }
        if (this.parent) {
            ParticleArcanery child = new ParticleArcanery(particle.getX(), particle.getY(), particle.getZ(), 0.0, 0.0, 0.0, new SlingRing(false, 5));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)child);
        } else {
            particle.setMotion(0.2 * (particle.getRandom().nextDouble() * 2.0 - 1.0), 0.2 * (particle.getRandom().nextDouble() * 2.0 - 1.0), 0.2 * (particle.getRandom().nextDouble() * 2.0 - 1.0));
            particle.func_187110_a(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
            particle.setRGBA(1.0f, 1.0f, 1.0f, 1.0f - (float)particle.getAge() / (float)particle.func_206254_h());
            particle.setSize(0.75f - (float)particle.getAge() / (float)particle.func_206254_h() * 0.75f);
        }
    }

    @Override
    public ResourceLocation texture() {
        return tex;
    }
}

