/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class Beam
extends ParticleEffect {
    private final Entity start;
    private final Entity end;
    private final Vector3d startOffset;
    private final Vector3d endOffset;
    private final double theta;
    private final int sections;
    private final float variance;
    private final float fadeIn;
    private final float fadeOut;
    private final float rateIn;
    private final int delay;
    private final float rateOut;
    private final float r;
    private final float g;
    private final float b;
    private final List<Vector3d> points = Lists.newArrayList();

    public Beam(Entity start, Entity end, Vector3d startOffset, Vector3d endOffset, double theta, int sections, float variance, float fadeIn, float fadeOut, float rateIn, int delay, float rateOut, float r, float g, float b) {
        this.start = start;
        this.end = end;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.theta = theta;
        this.sections = sections;
        this.variance = variance;
        this.fadeIn = fadeIn;
        this.fadeOut = fadeOut;
        this.rateIn = rateIn;
        this.delay = delay;
        this.rateOut = rateOut;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Override
    public void render(MatrixStack matrix, ParticleArcanery particle, IRenderTypeBuffer tessellator, float partialTicks) {
        matrix.func_227860_a_();
        IVertexBuilder builder = tessellator.getBuffer(PixelmonRendering.getParticleTypes());
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrix.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        for (int i = 1; i < this.points.size(); ++i) {
            Vector3d a = this.points.get(i - 1);
            Vector3d b = i + 1 == this.points.size() ? this.points.get(this.points.size() - 1) : this.points.get(i);
            float age = (float)particle.getAge() * this.rateIn;
            float alpha = MathHelper.func_76131_a((float)((age - (float)i) * this.fadeIn), (float)0.0f, (float)1.0f);
            if (particle.getAge() >= this.sections + this.delay) {
                float oldAge = (float)(particle.getAge() - (this.sections + this.delay)) * this.rateOut;
                alpha = MathHelper.func_76131_a((float)(((float)(this.sections - i) - oldAge) * this.fadeOut), (float)0.0f, (float)1.0f);
            }
            if (i > this.points.size() - 4) {
                int i2 = Math.abs(i - this.points.size()) - 1;
                alpha *= Math.min(1.0f, (float)i2 / 3.0f + 0.1f);
            }
            if (particle.getAge() > particle.func_206254_h() - 10) {
                int i2 = Math.abs(particle.getAge() - particle.func_206254_h()) - 1;
                alpha *= Math.min(1.0f, (float)i2 / 10.0f);
            }
            builder.func_227888_a_(mat, (float)a.field_72450_a, (float)a.field_72448_b, (float)a.field_72449_c).func_227885_a_(this.r, this.g, this.b, alpha / 3.0f).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(mat, (float)b.field_72450_a, (float)b.field_72448_b, (float)b.field_72449_c).func_227885_a_(this.r, this.g, this.b, alpha / 3.0f).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(mat, (float)a.field_72450_a, (float)a.field_72448_b, (float)a.field_72449_c).func_227885_a_(this.r, this.g, this.b, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(mat, (float)b.field_72450_a, (float)b.field_72448_b, (float)b.field_72449_c).func_227885_a_(this.r, this.g, this.b, alpha).func_227886_a_(0xF000F0).func_181675_d();
        }
        ((IRenderTypeBuffer.Impl)tessellator).func_228462_a_(PixelmonRendering.getParticleTypes());
        matrix.func_227865_b_();
    }

    @Override
    public boolean customRenderer() {
        return true;
    }

    @Override
    public void init(ParticleArcanery particle, World world, double x, double y, double z, double vx, double vy, double vz, float size) {
        Vector3d start = this.start.func_213303_ch().func_178787_e(this.startOffset);
        Vector3d end = this.end.func_213303_ch().func_178787_e(this.endOffset);
        double ptheta = 1.5707963267948966 - this.theta;
        double arc = (this.theta + 1.5707963267948966) / (double)this.sections;
        double h = start.field_72448_b - end.field_72448_b;
        double dx = (end.field_72450_a - start.field_72450_a) / (double)this.sections;
        double dz = (end.field_72449_c - start.field_72449_c) / (double)this.sections;
        double r = h / Math.cos(this.theta);
        this.points.add(start);
        for (int i = 1; i < this.sections; ++i) {
            Vector3d variance = RandomHelper.nextSpherePoint(this.variance);
            double nx = start.field_72450_a + dx * (double)i + variance.field_72450_a;
            double ny = end.field_72448_b + r * Math.sin(ptheta + arc * (double)i) + variance.field_72448_b;
            double nz = start.field_72449_c + dz * (double)i + variance.field_72449_c;
            this.points.add(new Vector3d(nx, ny, nz));
        }
        this.points.add(end);
        particle.setRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        particle.setSize(0.05f);
        particle.func_187114_a((int)Math.floor(this.rateIn * (float)this.sections) + this.delay);
        double px = (start.field_72450_a + end.field_72450_a) / 2.0;
        double py = (start.field_72448_b + end.field_72448_b) / 2.0;
        double pz = (start.field_72449_c + end.field_72449_c) / 2.0;
        particle.func_187109_b(px, py, pz);
        particle.setPrevPos(px, py, pz);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.incrementAge();
        if (particle.getAge() >= particle.func_206254_h()) {
            particle.func_187112_i();
        }
    }

    @Override
    public ResourceLocation texture() {
        return null;
    }
}

