/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerMovesScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerStatsScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.StringTextComponent;

public class PokeCheckerButton
extends IndexedButton {
    private Screen parent;
    private PokemonStorage storage;
    private StoragePosition position;
    private Pokemon pokemon;
    private MiniButton summary = new MiniButton(0, I18n.func_135052_a((String)"gui.screenpokechecker.summary", (Object[])new Object[0]), 10, 15);
    private MiniButton moves = new MiniButton(1, I18n.func_135052_a((String)"gui.screenpokechecker.moves", (Object[])new Object[0]), 10, 34);
    private MiniButton stats = new MiniButton(2, I18n.func_135052_a((String)"gui.screenpokechecker.stats", (Object[])new Object[0]), 10, 53);

    public PokeCheckerButton(Screen parent) {
        super(-1, 0, 0, 67, 75, StringTextComponent.field_240750_d_, button -> {});
        this.parent = parent;
        this.field_230693_o_ = false;
    }

    public void setPokemon(PokemonStorage storage, StoragePosition position, Pokemon pokemon, double mouseX, double mouseY) {
        this.storage = storage;
        this.position = position;
        this.pokemon = pokemon;
        this.field_230693_o_ = this.storage != null && this.position != null && this.pokemon != null;
        this.field_230690_l_ = (int)(mouseX - 73.0);
        this.field_230691_m_ = (int)(mouseY - 10.0);
        if (this.field_230691_m_ + this.field_230689_k_ > this.parent.field_230709_l_) {
            this.field_230691_m_ = this.parent.field_230709_l_ - this.field_230689_k_;
        }
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return this.field_230693_o_ && super.func_231047_b_(mouseX, mouseY);
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        PlayerInventory inventory = this.parent.getMinecraft().field_71439_g.field_71071_by;
        ItemStack currentItem = inventory.func_70445_o().func_77946_l();
        if (!currentItem.func_190926_b()) {
            return true;
        }
        if (this.summary.hovered) {
            SoundHelper.playButtonPressSound();
            Minecraft.func_71410_x().func_147108_a((Screen)new PokeCheckerScreen(this.storage, this.position, this.parent));
        } else if (this.moves.hovered) {
            SoundHelper.playButtonPressSound();
            Minecraft.func_71410_x().func_147108_a((Screen)new PokeCheckerMovesScreen(this.storage, this.position, this.parent));
        } else if (this.stats.hovered) {
            SoundHelper.playButtonPressSound();
            Minecraft.func_71410_x().func_147108_a((Screen)new PokeCheckerStatsScreen(this.storage, this.position, this.parent));
        }
        return true;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230693_o_) {
            this.field_230692_n_ = this.isHovered(mouseX, mouseY);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(Resources.pokecheckerPopup);
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, 0, 0, this.field_230688_j_, this.field_230689_k_);
            this.summary.render(matrix, mouseX, mouseY, partialTicks);
            this.moves.render(matrix, mouseX, mouseY, partialTicks);
            this.stats.render(matrix, mouseX, mouseY, partialTicks);
            ScreenHelper.drawCenteredString(matrix, this.pokemon.getDisplayName(), (float)this.field_230690_l_ + (float)this.field_230688_j_ / 2.0f, (float)(this.field_230691_m_ + 2), 0xFFFFFF, true);
            this.summary.drawText(matrix);
            this.moves.drawText(matrix);
            this.stats.drawText(matrix);
        }
    }

    private class MiniButton {
        private static final int HOVER_WIDTH = 47;
        private static final int HOVER_HEIGHT = 13;
        public final int id;
        private int offsetX;
        private int offsetY;
        private String text;
        private int tempX;
        private int tempY;
        public boolean hovered;

        private MiniButton(int id, String text, int offsetX, int offsetY) {
            this.id = id;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.text = text;
        }

        public boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.tempX && mouseY >= this.tempY && mouseX < this.tempX + 47 && mouseY < this.tempY + 13;
        }

        public void render(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            this.tempX = PokeCheckerButton.this.field_230690_l_ + this.offsetX;
            this.tempY = PokeCheckerButton.this.field_230691_m_ + this.offsetY;
            this.hovered = this.isHovered(mouseX, mouseY);
            if (this.hovered) {
                PokeCheckerButton.this.func_238474_b_(matrix, this.tempX, this.tempY, 1, 76, 47, 13);
            }
        }

        public void drawText(MatrixStack matrix) {
            ScreenHelper.drawCenteredString(matrix, this.text, (float)this.tempX + 23.5f, (float)this.tempY + 6.5f - 4.0f, this.hovered ? 0xFFFFA0 : 0xFFFFFF, true);
        }
    }
}

