/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.NonNullList;

public class DropDownManager {
    private final List<DropDown> dropDowns = NonNullList.func_191196_a();
    private boolean lastMouse;

    public void drawDropDowns(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        DropDown active = null;
        int tempMouseX = mouseX;
        int tempMouseY = mouseY;
        for (DropDown dropDown : this.dropDowns) {
            if (dropDown == null || !dropDown.active) continue;
            active = dropDown;
            break;
        }
        for (int i = 0; i < this.dropDowns.size(); ++i) {
            DropDown dropDown;
            dropDown = this.dropDowns.get(i);
            if (dropDown == null || dropDown.active || !dropDown.getVisible()) continue;
            dropDown.render(matrix, mouseX, mouseY, partialTicks, active);
        }
        if (active != null) {
            active.render(matrix, tempMouseX, tempMouseY, partialTicks, active);
        }
        this.lastMouse = Minecraft.func_71410_x().field_71417_B.func_198030_b();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean selected = false;
        boolean activeExists = false;
        for (DropDown dropDown : this.dropDowns) {
            if (!dropDown.active) continue;
            activeExists = true;
        }
        for (int i = 0; i < this.dropDowns.size(); ++i) {
            DropDown dropDown;
            dropDown = this.dropDowns.get(i);
            if (!dropDown.active && activeExists || dropDown == null || selected) continue;
            if (dropDown.isMouseOver((int)mouseX, (int)mouseY)) {
                selected = true;
                dropDown.mouseClicked(mouseX, mouseY, mouseButton);
            } else {
                dropDown.active = false;
            }
            selected = dropDown.active || dropDown.getLastSelected();
        }
        return selected;
    }

    void mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (int i = 0; i < this.dropDowns.size(); ++i) {
            DropDown dropDown = this.dropDowns.get(i);
            if (dropDown == null) continue;
            dropDown.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        boolean selected = false;
        for (int i = 0; i < this.dropDowns.size(); ++i) {
            DropDown dropDown = this.dropDowns.get(i);
            if (dropDown == null) continue;
            if (dropDown.isMouseOver((int)mouseX, (int)mouseY)) {
                selected = true;
                dropDown.mouseScrolled(mouseX, mouseY, delta);
            }
            selected = selected || dropDown.getLastSelected();
        }
        return selected;
    }

    public void addDropDown(DropDown dropDown) {
        dropDown.setManager(this);
        this.dropDowns.add(dropDown);
    }

    public void removeDropDown(DropDown dropDown) {
        this.dropDowns.remove(dropDown);
    }

    public void clearDropDowns() {
        this.dropDowns.clear();
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.dropDowns == null || this.dropDowns.isEmpty()) {
            return false;
        }
        return this.dropDowns.stream().anyMatch(dropDown -> dropDown != null && dropDown.isMouseOver(mouseX, mouseY));
    }

    boolean getLastMouse() {
        return this.lastMouse;
    }
}

