/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.starter;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ObjectHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ShadowDelete;
import com.pixelmonmod.pixelmon.client.gui.starter.Shadow;
import com.pixelmonmod.pixelmon.client.gui.starter.ShadowSize;
import com.pixelmonmod.pixelmon.client.gui.starter.StarterButton;
import com.pixelmonmod.pixelmon.client.gui.starter.StarterScreenPhase;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.SWSHButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ChooseStarterPacket;
import com.pixelmonmod.pixelmon.config.starter.Starter;
import com.pixelmonmod.pixelmon.config.starter.StarterList;
import com.pixelmonmod.pixelmon.config.starter.StarterOption;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ChooseStarterScreen
extends Screen
implements ShadowDelete {
    private StarterScreenPhase currentScreen = StarterScreenPhase.Copyright;
    private int clickedIndex = -1;
    protected final boolean[] options;
    private int page;
    private int pages;
    private final List<StarterButton> starterButtons = Lists.newArrayList();
    private final List<ImageButton> pageButtons = Lists.newArrayList();
    private final List<SWSHButton> buttons = Lists.newArrayList();
    private final List<Shadow> shadowList = Lists.newArrayList();
    private int ticksToChange = 100;

    public ChooseStarterScreen() {
        this(new boolean[StarterList.getOptions().size()], 0);
    }

    public ChooseStarterScreen(boolean[] options, int page) {
        super(StringTextComponent.field_240750_d_);
        Random r = RandomHelper.rand;
        while (this.shadowList.size() < 5) {
            float f = r.nextFloat();
            ShadowSize shadowType = f < 0.2f ? ShadowSize.Large : (f < 0.5f ? ShadowSize.Medium : ShadowSize.Large);
            this.shadowList.add(new Shadow(shadowType, this, r.nextFloat()));
        }
        this.options = options;
        this.page = page;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (!ServerStorageDisplay.showStarterScreen) {
            return;
        }
        if (this.currentScreen == StarterScreenPhase.Choose) {
            this.initButtons();
        }
    }

    private void initButtons() {
        this.buttons.clear();
        this.pageButtons.clear();
        this.starterButtons.clear();
        int index = 0;
        for (Starter starter : StarterList.getStarters()) {
            starter.resetDisplay();
            StarterButton button2 = new StarterButton(index, this.field_230708_k_ / 2 - 96 + 25 * (starter.getX() - 4), this.field_230709_l_ / 2 - 64 + starter.getY() * 16, starter.getScale(), this, this::actionPerformed);
            if (index == this.clickedIndex) {
                button2.clicked = true;
            }
            button2.field_230694_p_ = starter.getPage() == this.page;
            button2.field_230693_o_ = button2.field_230694_p_;
            this.starterButtons.add(button2);
            ++index;
            this.pages = Math.max(this.pages, starter.getPage() + 1);
        }
        this.buttons.add(new SWSHButton((float)this.field_230708_k_ / 2.0f - 90.0f, (float)this.field_230709_l_ * 2.0f / 3.0f + 22.0f, 1.0, 180.0, 16.0, I18n.func_135052_a((String)"gui.starter.begin", (Object[])new Object[0]), button -> {
            if (this.isSelected()) {
                NetworkHelper.sendToServer(new ChooseStarterPacket(this.clickedIndex, this.options));
                ServerStorageDisplay.showStarterScreen = false;
                try {
                    this.field_230706_i_.field_71439_g.func_71053_j();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }).setVisible(this.isSelected()));
        ImageButton lhs = new ImageButton(0, (int)((float)this.field_230708_k_ * 0.02f) - 5, (int)((float)this.field_230709_l_ / 2.0f - 32.0f) - 3, 10, 36, Resources.starterLeft, 1.0f, 1.0f, 1.0f, button -> {
            if (this.page - 1 < 0) {
                if (StarterList.shouldLoop()) {
                    this.page = this.pages - 1;
                }
            } else {
                --this.page;
            }
        });
        lhs.field_230693_o_ = this.pages != 1 && (StarterList.shouldLoop() || this.page < this.pages - 1);
        lhs.field_230694_p_ = lhs.field_230693_o_;
        this.pageButtons.add(lhs);
        ImageButton rhs = new ImageButton(0, (int)((float)this.field_230708_k_ - (float)this.field_230708_k_ * 0.02f) - 5, (int)((float)this.field_230709_l_ / 2.0f - 32.0f) - 3, 10, 36, Resources.starterRight, 1.0f, 1.0f, 1.0f, button -> {
            if (this.page + 1 >= this.pages) {
                if (StarterList.shouldLoop()) {
                    this.page = 0;
                }
            } else {
                ++this.page;
            }
        });
        rhs.field_230693_o_ = this.pages != 1 && (StarterList.shouldLoop() || this.page > 0);
        rhs.field_230694_p_ = rhs.field_230693_o_;
        this.pageButtons.add(rhs);
        int optionIndex = 0;
        for (StarterOption option : StarterList.getOptions()) {
            String labelKey = option.getLabel(this.options[optionIndex]);
            int finalOptionIndex = optionIndex;
            this.buttons.add(new SWSHButton((float)this.field_230708_k_ / 2.0f - 100.0f + (float)(25 * (option.getX() - 4)) - (float)(option.getWidth() * 25) / 4.0f, (float)this.field_230709_l_ / 2.0f - 64.0f + (float)(option.getY() * 16), 1.0, option.getWidth() * 25, 14.0, I18n.func_188566_a((String)labelKey) ? I18n.func_135052_a((String)labelKey, (Object[])new Object[0]) : labelKey, button -> {
                this.options[finalOptionIndex] = !this.options[finalOptionIndex];
                this.initButtons();
            }).setVisible(!this.isSelected()));
            ++optionIndex;
        }
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public boolean func_231042_a_(char i, int i1) {
        return false;
    }

    public void actionPerformed(Button button) {
        if (button instanceof StarterButton && ((StarterButton)button).starterIndex != -1) {
            StarterButton starterButton = (StarterButton)button;
            for (StarterButton buttonL : this.starterButtons) {
                if (buttonL == button || buttonL == null) continue;
                buttonL.clicked = false;
            }
            starterButton.clicked = !starterButton.clicked;
            this.clickedIndex = starterButton.clicked ? starterButton.starterIndex : -1;
        }
    }

    public void func_230430_a_(MatrixStack matrix, int par1, int par2, float par3) {
        if (this.field_230706_i_ != null) {
            ObjectHelper.ifNotNull(this.field_230706_i_.func_110434_K().func_229267_b_(Resources.starterLeft), t -> t.setBlurMipmap(true, true));
            ObjectHelper.ifNotNull(this.field_230706_i_.func_110434_K().func_229267_b_(Resources.starterRight), t -> t.setBlurMipmap(true, true));
        }
        Color color = StarterList.getColor(this.page);
        ScreenHelper.drawImageQuad(Resources.starterBackground, matrix, 0.0f, 0.0f, this.field_230708_k_, this.field_230709_l_, 0.0f, 0.0f, 1.0f, 1.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, 0.0f);
        for (Shadow aShadowList : this.shadowList) {
            aShadowList.draw(matrix, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
        RenderSystem.enableBlend();
        ScreenHelper.drawImageQuad(Resources.starterBorders, matrix, 0.0f, 0.0f, this.field_230708_k_, this.field_230709_l_, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        if (this.currentScreen == StarterScreenPhase.Copyright) {
            ChooseStarterScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.starter.trademark1", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 30), (int)0xFFFFFF);
            ChooseStarterScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.starter.trademark2", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 17), (int)0xFFFFFF);
            ChooseStarterScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.starter.trademark3", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 5), (int)0xFFFFFF);
        } else if (this.currentScreen == StarterScreenPhase.Choose) {
            if (this.buttons.isEmpty()) {
                this.func_231160_c_();
                if (this.buttons.isEmpty()) {
                    this.field_230706_i_.field_71439_g.func_71053_j();
                }
            }
            ChooseStarterScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_188566_a((String)StarterList.getText()[0]) ? I18n.func_135052_a((String)StarterList.getText()[0], (Object[])new Object[0]) : StarterList.getText()[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 92), (int)0xFFFFFF);
            ChooseStarterScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_188566_a((String)StarterList.getText()[1]) ? I18n.func_135052_a((String)StarterList.getText()[1], (Object[])new Object[0]) : StarterList.getText()[1]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 80), (int)0xFFFFFF);
            boolean hovering = false;
            if (!this.isSelected()) {
                for (StarterButton starterButton : this.starterButtons) {
                    if (!starterButton.func_231047_b_(par1, par2)) continue;
                    hovering = true;
                    Species species = StarterList.getStarters().get(starterButton.starterIndex).getDisplay(this.options).getSpecies();
                    String name = TextFormatting.BOLD + species.getLocalizedName();
                    matrix.func_227862_a_(0.9f, 0.9f, 0.9f);
                    ScreenHelper.drawCenteredSplitString(matrix, I18n.func_135052_a((String)("pixelmon." + species.getName().toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]), (float)this.field_230708_k_ / 1.8f, this.field_230709_l_ - 35, 300, 0xFFFFFF, false);
                    matrix.func_227862_a_(1.1111112f, 1.1111112f, 1.1111112f);
                    this.field_230706_i_.func_110434_K().func_110577_a(Resources.buttonTexture);
                    ScreenHelper.drawCenteredString(matrix, name, (float)this.field_230708_k_ / 2.0f, (float)(this.field_230709_l_ * 2) / 3.0f, 0xFFFFFF);
                }
            } else {
                for (StarterButton starterButton : this.starterButtons) {
                    if (starterButton == null || !starterButton.clicked) continue;
                    Species species = StarterList.getStarters().get(starterButton.starterIndex).getDisplay(this.options).getSpecies();
                    String name = TextFormatting.BOLD + species.getLocalizedName();
                    ScreenHelper.drawCenteredString(matrix, name, (float)this.field_230708_k_ / 2.0f, (float)(this.field_230709_l_ * 2) / 3.0f, 0xFFFFFF);
                }
            }
            for (StarterButton starterButton : this.starterButtons) {
                starterButton.func_230430_a_(matrix, par1, par2, par3);
            }
            for (ImageButton imageButton : this.pageButtons) {
                if (!imageButton.field_230694_p_) continue;
                matrix.func_227860_a_();
                if (imageButton.func_231047_b_(par1, par2)) {
                    long tick = System.currentTimeMillis();
                    float dx = tick % 2000L - 1000L;
                    if (dx < 0.0f) {
                        dx = Math.abs(dx);
                    }
                    matrix.func_227861_a_((double)((dx -= 500.0f) * 0.004f), 0.0, 0.0);
                }
                imageButton.func_230430_a_(matrix, par1, par2, par3);
                matrix.func_227865_b_();
            }
            if (!hovering) {
                for (SWSHButton sWSHButton : this.buttons) {
                    sWSHButton.draw(matrix, par1, par2, par3);
                }
            }
        }
        super.func_230430_a_(matrix, par1, par2, par3);
    }

    public void func_231023_e_() {
        try {
            super.func_231023_e_();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.currentScreen == StarterScreenPhase.Copyright) {
            --this.ticksToChange;
            if (this.ticksToChange <= 0) {
                this.currentScreen = StarterScreenPhase.Choose;
                this.func_231160_c_();
            }
        }
        for (int i = 0; i < this.shadowList.size(); ++i) {
            this.shadowList.get(i).update();
        }
        if (Minecraft.func_71410_x().field_71439_g.func_70681_au().nextFloat() < 0.008f) {
            float f = this.field_230706_i_.field_71439_g.func_70681_au().nextFloat();
            ShadowSize shadowType = f < 0.2f ? ShadowSize.Large : (f < 0.5f ? ShadowSize.Medium : ShadowSize.Large);
            this.shadowList.add(new Shadow(shadowType, this));
        }
    }

    public boolean func_231044_a_(double x, double y, int b) {
        boolean reload = false;
        if (this.currentScreen == StarterScreenPhase.Copyright) {
            this.currentScreen = StarterScreenPhase.Choose;
            this.func_231160_c_();
        } else {
            for (StarterButton starterButton : this.starterButtons) {
                if (!starterButton.field_230693_o_ || !starterButton.func_231044_a_(x, y, b)) continue;
                reload = true;
                break;
            }
            if (!reload) {
                for (SWSHButton sWSHButton : this.buttons) {
                    if (!sWSHButton.isInteractable() || !sWSHButton.isWithin(x, y)) continue;
                    sWSHButton.onClick(x, y, b);
                    reload = true;
                    break;
                }
            }
            if (!reload) {
                for (ImageButton imageButton : this.pageButtons) {
                    if (!imageButton.field_230693_o_ || !imageButton.func_231044_a_(x, y, b)) continue;
                    reload = true;
                    break;
                }
            }
        }
        if (!reload) {
            for (StarterButton starterButton : this.starterButtons) {
                starterButton.clicked = false;
                this.clickedIndex = -1;
            }
        }
        this.initButtons();
        return super.func_231044_a_(x, y, b);
    }

    @Override
    public void removeShadow(Shadow shadow) {
        this.shadowList.remove(shadow);
    }

    private boolean isSelected() {
        return this.clickedIndex != -1;
    }
}

