/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleMenuElement;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.PokemonMenuButton;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ItemMenuButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BagPacket;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ApplyToPokemon
extends BattleScreen {
    private BattleMenuElement<ItemMenuButton> bagMenu;
    private BattleMenuElement<PokemonMenuButton> pokeMenu;

    public ApplyToPokemon(com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void render(MatrixStack matrix, int width, int height, int mouseX, int mouseY, float partialTicks) {
        CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        this.renderBackground(matrix, width, height, mouseX, mouseY, 0);
        this.drawButtons(matrix, mouseX, mouseY, partialTicks);
        try {
            this.parent.battleLog.drawElement(matrix, 40, height - 80, Math.min(this.field_230708_k_ - 80, 260), 80, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AtomicInteger index = new AtomicInteger();
        List<ItemData> bag = this.bm.getBagItems(this.bm.bagSection);
        List items = bag.stream().map(it -> new ItemMenuButton(index.getAndIncrement(), it.getItemStack(), this)).collect(Collectors.toList());
        this.bagMenu = new BattleMenuElement(this, (ITextComponent)new StringTextComponent(this.bm.bagSection.getLocalizedName()), items);
        this.bagMenu.setPosition(0, this.field_230709_l_ - 240, 180, 240);
        this.bagMenu.drawElement(matrix, 1.0f);
        ScreenHelper.drawGradientRect(matrix, 0, 0, 0.0f, this.field_230708_k_, this.field_230709_l_, 0x70000000, 0x70000000);
        index.set(0);
        List pigs = this.bm.fullOurPokemon.stream().map(it -> new PokemonMenuButton(index.getAndIncrement(), (PixelmonClientData)it, this)).collect(Collectors.toList());
        this.pokeMenu = new BattleMenuElement(this, (ITextComponent)new TranslationTextComponent("gui.choosepokemon.select"), pigs);
        this.pokeMenu.setPosition(180, this.field_230709_l_ - 240, 180, 240);
        this.pokeMenu.drawElement(matrix, 1.0f);
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (this.bm.isHealing) {
            return;
        }
        if (this.pokeMenu.isMouseOver(mouseX, mouseY)) {
            if (this.pokeMenu.isOverReturnButton(mouseX, mouseY)) {
                this.bm.setMode(BattleMode.CHOOSE_BAG);
            } else if (!this.pokeMenu.handleClickPageTurn(mouseX, mouseY)) {
                List<PokemonMenuButton> buttons = this.pokeMenu.getPageButtons();
                for (PokemonMenuButton button : buttons) {
                    if (!button.func_231044_a_(mouseX, mouseY, 0)) continue;
                    PixelmonClientData pokemonToApplyTo = null;
                    PixelmonClientData chosenPokemon = button.getPig();
                    Item item = this.bm.itemToUse.getItemStack().func_77973_b();
                    if (chosenPokemon != null) {
                        if (item == PixelmonItems.revive.getItem() || item == PixelmonItems.max_revive.getItem() || item == PixelmonItems.revival_herb.getItem()) {
                            if (chosenPokemon.health.get() <= 0.0) {
                                pokemonToApplyTo = chosenPokemon;
                            }
                        } else if (chosenPokemon.health.get() > 0.0) {
                            pokemonToApplyTo = chosenPokemon;
                        }
                    }
                    if (pokemonToApplyTo == null) continue;
                    if (item == PixelmonItems.ether || item == PixelmonItems.max_ether || item == PixelmonItems.leppa_berry) {
                        this.bm.setMode(BattleMode.CHOOSE_ETHER);
                        continue;
                    }
                    this.bm.selectedActions.add(new BagPacket(this.bm.getCurrentPokemon().pokemonUUID, pokemonToApplyTo.pokemonUUID, this.bm.itemToUse.getItemStack(), this.bm.battleControllerIndex));
                    this.bm.selectedMove();
                }
            }
        }
    }
}

