/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleBaseScreen;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;

public abstract class BattleScreen
extends BattleBaseScreen {
    public static final ResourceLocation BACKGROUND = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/background.png");
    public static final ResourceLocation DETAILS = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_details.png");
    public static final ResourceLocation MENU_BAG = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_bag.png");
    public static final ResourceLocation MENU_BAG_DISABLED = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_bag_disabled.png");
    public static final ResourceLocation MENU_BAG_ICON = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_bag_icon.png");
    public static final ResourceLocation MENU_POKE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_poke.png");
    public static final ResourceLocation MENU_POKE_DISABLED = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_poke_disabled.png");
    public static final ResourceLocation MENU_POKE_ICON = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_poke_icon.png");
    public static final ResourceLocation MENU_RUN = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_run.png");
    public static final ResourceLocation MENU_RUN_DISABLED = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_run_disabled.png");
    public static final ResourceLocation MENU_RUN_ICON = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_run_icon.png");
    int chatArea;
    int detailsStart;

    public BattleScreen(com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    public void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230710_m_.add(new ActionButton(EnumBattleButton.BAG, this));
        this.field_230710_m_.add(new ActionButton(EnumBattleButton.POKE, this));
        this.field_230710_m_.add(new ActionButton(EnumBattleButton.RUN, this));
        if (ClientProxy.battleManager.rules.hasClause(BattleClauseRegistry.BAG_CLAUSE)) {
            ((Widget)this.field_230710_m_.get((int)0)).field_230693_o_ = false;
        }
        if (!this.bm.canSwitch) {
            ((Widget)this.field_230710_m_.get((int)1)).field_230693_o_ = false;
        }
        if (!this.bm.canFlee || ClientProxy.battleManager.rules.hasClause(BattleClauseRegistry.FORFEIT_CLAUSE)) {
            ((Widget)this.field_230710_m_.get((int)2)).field_230693_o_ = false;
        }
    }

    @Override
    public void renderBackground(MatrixStack matrix, int width, int height, int mouseX, int mouseY, int vOffset) {
        this.chatArea = width - 40 - 80;
        ScreenHelper.drawImage(BACKGROUND, matrix, 0.0f, (float)height - 82.1f, (float)width, 83.1f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.detailsStart = this.field_230708_k_ - 80;
        ScreenHelper.drawImage(DETAILS, matrix, (float)this.detailsStart, (float)(height - 80), 80.0f, 80.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    public void drawButtons(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ((Widget)this.field_230710_m_.get((int)1)).field_230693_o_ = this.bm.canSwitch;
        ((Widget)this.field_230710_m_.get((int)2)).field_230693_o_ = this.bm.canFlee && !ClientProxy.battleManager.rules.hasClause(BattleClauseRegistry.FORFEIT_CLAUSE);
        for (Widget button : this.field_230710_m_) {
            button.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public boolean handleButtonClick(double mouseX, double mouseY) {
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof ActionButton) || !button.func_231044_a_(mouseX, mouseY, 0)) continue;
            this.bm.dynamaxing = false;
            this.bm.megaEvolving = false;
            this.bm.showZMoves = false;
            ActionButton action = (ActionButton)button;
            if (action.button == EnumBattleButton.RUN) {
                this.bm.selectRunAction(this.bm.getCurrentPokemon().pokemonUUID);
            } else {
                ClientProxy.battleManager.setMode(action.button.getBattleMode());
            }
            return true;
        }
        return false;
    }

    public static enum EnumBattleButton {
        BAG,
        POKE,
        RUN;


        @Nonnull
        public BattleMode getBattleMode() {
            switch (this) {
                case BAG: {
                    return BattleMode.CHOOSE_BAG;
                }
                case POKE: {
                    return BattleMode.CHOOSE_POKEMON;
                }
                case RUN: {
                    return BattleMode.YES_NO_FORFEIT;
                }
            }
            return null;
        }

        @Nonnull
        public ResourceLocation getTexture(boolean disabled) {
            switch (this) {
                case BAG: {
                    return disabled ? MENU_BAG_DISABLED : MENU_BAG;
                }
                case POKE: {
                    return disabled ? MENU_POKE_DISABLED : MENU_POKE;
                }
                case RUN: {
                    return disabled ? MENU_RUN_DISABLED : MENU_RUN;
                }
            }
            return null;
        }

        @Nonnull
        public void drawButton(MatrixStack matrix, Screen screen, boolean active) {
            switch (this) {
                case BAG: {
                    ScreenHelper.drawImage(this.getTexture(!active), matrix, -1.0f, (float)this.getY(), 40.0f, 24.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case RUN: {
                    ScreenHelper.drawImage(this.getTexture(!active), matrix, 0.0f, (float)this.getY(), 40.0f, 24.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case POKE: {
                    ScreenHelper.drawImage(this.getTexture(!active), matrix, 0.0f, (float)this.getY(), 41.0f, 26.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
        }

        public int getY() {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen == null) {
                return 0;
            }
            switch (this) {
                case BAG: {
                    return screen.field_230709_l_ - 72 - 8;
                }
                case POKE: {
                    return screen.field_230709_l_ - 48 - 5;
                }
                case RUN: {
                    return screen.field_230709_l_ - 24;
                }
            }
            return 0;
        }

        @Nonnull
        public ResourceLocation getIcon() {
            switch (this) {
                case BAG: {
                    return MENU_BAG_ICON;
                }
                case POKE: {
                    return MENU_POKE_ICON;
                }
                case RUN: {
                    return MENU_RUN_ICON;
                }
            }
            return null;
        }

        @Nonnull
        public void drawIcon(MatrixStack matrix, Screen screen) {
            if (screen == null) {
                return;
            }
            switch (this) {
                case BAG: {
                    ScreenHelper.drawImage(this.getIcon(), matrix, 8.0f, (float)(screen.field_230709_l_ - 72 - 3), 16.0f, 14.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case POKE: {
                    ScreenHelper.drawImage(this.getIcon(), matrix, 8.0f, (float)(screen.field_230709_l_ - 48), 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case RUN: {
                    ScreenHelper.drawImage(this.getIcon(), matrix, 8.0f, (float)(screen.field_230709_l_ - 24 + 5), 20.0f, 14.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
        }
    }

    public static class ActionButton
    extends Button {
        public final EnumBattleButton button;
        public final BattleScreen parent;
        public boolean hovered;
        private int hoveredFrames = 0;
        private boolean isPressed;

        public ActionButton(EnumBattleButton button, BattleScreen parent) {
            super(0, 0, button == EnumBattleButton.POKE ? 41 : 40, button == EnumBattleButton.POKE ? 26 : 24, StringTextComponent.field_240750_d_, action -> {});
            this.button = button;
            this.field_230691_m_ = button.getY();
            this.parent = parent;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            Minecraft mc = Minecraft.func_71410_x();
            this.hovered = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            this.hoveredFrames = this.hovered ? Math.min(3, this.hoveredFrames + 1) : Math.max(0, this.hoveredFrames - 1);
            matrix.func_227860_a_();
            if ((this.parent.mode == BattleMode.MAIN_MENU || this.parent.mode == BattleMode.CHOOSE_ATTACK) && this.hoveredFrames > 0 && this.field_230693_o_ && this.field_230694_p_) {
                matrix.func_227861_a_((double)(-this.hoveredFrames), 0.0, 0.0);
            }
            this.button.drawButton(matrix, mc.field_71462_r, this.field_230693_o_);
            matrix.func_227865_b_();
            this.button.drawIcon(matrix, mc.field_71462_r);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            this.isPressed = super.func_231044_a_(mouseX, mouseY, button);
            return this.isPressed;
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            this.isPressed = false;
            return true;
        }
    }
}

