/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.requirement.impl.EggRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenderRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.ScoreboardJustification;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.lwjgl.opengl.GL11;

public class ScreenHelper {
    public static FontRenderer getFontRenderer(String font, boolean extendedColours) {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static void drawString(MatrixStack matrix, String text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawString(matrix, Minecraft.func_71410_x().field_71466_p, text, x, y, color, dropShadow, false);
    }

    public static void drawString(MatrixStack matrix, String text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        ScreenHelper.drawString(matrix, Minecraft.func_71410_x().field_71466_p, text, x, y, color, dropShadow, unicode);
    }

    public static void drawString(MatrixStack matrix, FontRenderer fr, String text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawString(matrix, fr, text, x, y, color, dropShadow, false);
    }

    public static void drawString(MatrixStack matrix, FontRenderer fr, String text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        if (dropShadow) {
            fr.func_238405_a_(matrix, text, x, y, color);
        } else {
            fr.func_238421_b_(matrix, text, x, y, color);
        }
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
    }

    public static void drawString(MatrixStack matrix, FontRenderer fr, ITextComponent text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        if (dropShadow) {
            fr.func_243246_a(matrix, text, x, y, color);
        } else {
            fr.func_243248_b(matrix, text, x, y, color);
        }
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
    }

    public static void drawString(MatrixStack matrix, FontRenderer fr, String text, float x, float y, int color, boolean dropShadow, boolean unicode, boolean centered) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        if (centered) {
            ScreenHelper.drawCenteredString(matrix, text, x, y, color, dropShadow);
        } else if (dropShadow) {
            fr.func_238405_a_(matrix, text, x, y, color);
        } else {
            fr.func_238421_b_(matrix, text, x, y, color);
        }
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
    }

    public static void drawInUnicode(Runnable runnable) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        Minecraft.func_71410_x().func_238209_b_(true);
        runnable.run();
        Minecraft.func_71410_x().func_238209_b_(force);
    }

    public static void drawStringRightAligned(MatrixStack matrix, String text, float x, float y, int color) {
        ScreenHelper.drawStringRightAligned(matrix, text, x, y, color, false);
    }

    public static void drawStringRightAligned(MatrixStack matrix, String text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawStringRightAligned(matrix, text, x, y, color, dropShadow, false);
    }

    public static void drawStringRightAligned(MatrixStack matrix, String text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ScreenHelper.drawString(matrix, fontRenderer, text, x -= (float)fontRenderer.func_78256_a(text), y, color, dropShadow, unicode);
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
    }

    public static void drawScaledString(MatrixStack matrix, String text, float x, float y, int color, float fontSize) {
        float scalar = fontSize / 16.0f;
        matrix.func_227860_a_();
        matrix.func_227862_a_(scalar, scalar, 1.0f);
        ScreenHelper.drawString(matrix, text, x / scalar, y / scalar, color);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.func_227865_b_();
    }

    public static void drawScaledCenteredString(MatrixStack matrix, String text, float x, float y, int color, float fontSize) {
        float scalar = fontSize / 16.0f;
        matrix.func_227860_a_();
        matrix.func_227862_a_(scalar, scalar, 1.0f);
        ScreenHelper.drawCenteredString(matrix, text, x / scalar, y / scalar, color);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.func_227865_b_();
    }

    public static void drawScaledStringWithOutline(MatrixStack matrix, String text, float x, float y, int color, int outlineColor, float fontSize, float outline) {
        int i = 0;
        while (i < text.length()) {
            String character = text.substring(i, i + 1);
            ScreenHelper.drawScaledCenteredString(matrix, character, x, y - outline / 4.0f, outlineColor, fontSize);
            ScreenHelper.drawScaledCenteredString(matrix, character, x, y, color, fontSize - outline);
            if (i == 0) {
                x -= (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(String.valueOf(text.charAt(i))) / 2.0f;
            }
            x += (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(String.valueOf(text.charAt(i++)));
        }
    }

    public static void drawScaledStringRightAligned(MatrixStack matrix, String text, float x, float y, int color, boolean dropShadow, float fontSize) {
        float scalar = fontSize / 16.0f;
        matrix.func_227860_a_();
        matrix.func_227862_a_(scalar, scalar, 1.0f);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        x = (float)((double)x - (double)((float)fontRenderer.func_78256_a(text) * fontSize) / 16.0);
        ScreenHelper.drawString(matrix, fontRenderer, text, x / scalar, y / scalar, color, dropShadow, false);
        matrix.func_227865_b_();
    }

    public static String splitStringToFit(String s, int font, int width) {
        int i = 0;
        block0: while (i < s.length()) {
            int j = 0;
            while (j < width) {
                if (++i >= s.length()) {
                    return s;
                }
                j = (int)((double)j + (double)Minecraft.func_71410_x().field_71466_p.func_78256_a(String.valueOf(s.charAt(i))) * ((double)font / 16.0));
            }
            if (s.substring(0, i).contains(" ")) {
                for (j = i; j > 0; --j) {
                    if (s.charAt(j) != ' ') continue;
                    s = s.substring(0, j).trim() + "\n" + s.substring(j).trim();
                    continue block0;
                }
                continue;
            }
            s = s.substring(0, i).trim() + "\n" + s.substring(i).trim();
        }
        return s;
    }

    public static void simpleDrawImageQuad(MatrixStack matrixStack, float x, float y, float w, float h, float us, float vs, float ue, float ve, float zLevel) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, x, y + h, zLevel).func_225583_a_(us, ve).func_181675_d();
        buffer.func_227888_a_(matrix, x + w, y + h, zLevel).func_225583_a_(ue, ve).func_181675_d();
        buffer.func_227888_a_(matrix, x + w, y, zLevel).func_225583_a_(ue, vs).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, zLevel).func_225583_a_(us, vs).func_181675_d();
        buffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
    }

    public static void drawImageQuad(ResourceLocation texture, MatrixStack matrix, float x, float y, float w, float h, float us, float vs, float ue, float ve, float zLevel) {
        ScreenHelper.drawImageQuad(texture, matrix, x, y, w, h, us, vs, ue, ve, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
    }

    public static void drawImageQuad(ResourceLocation texture, MatrixStack matrix, float x, float y, float w, float h, float us, float vs, float ue, float ve, float a, float zLevel) {
        ScreenHelper.drawImageQuad(texture, matrix, x, y, w, h, us, vs, ue, ve, 1.0f, 1.0f, 1.0f, a, zLevel);
    }

    public static void drawImageQuad(ResourceLocation texture, MatrixStack matrix, float x, float y, float w, float h, float us, float vs, float ue, float ve, float r, float g, float b, float a, float zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture == null ? TextureManager.field_194008_a : texture);
        int texW = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4096);
        int texH = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4097);
        float u = ue - us;
        float v = ve - vs;
        matrix.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        int ix = (int)x;
        int iy = (int)y;
        matrix.func_227861_a_((double)(x - (float)ix), (double)(y - (float)iy), (double)zLevel);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)ix, (int)iy, (float)(us * (float)texW), (float)(vs * (float)texH), (int)((int)w), (int)((int)h), (int)(u == 1.0f ? (int)w : texW), (int)(v == 1.0f ? (int)h : texH));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.func_227865_b_();
    }

    public static void drawImageQuadUV(ResourceLocation texture, MatrixStack matrix, float x, float y, float w, float h, float us, float vs, float u, float v, float r, float g, float b, float a, float zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int texW = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4096);
        int texH = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4097);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)y, (double)zLevel);
        AbstractGui.func_238466_a_((MatrixStack)matrix, (int)0, (int)0, (int)((int)w), (int)((int)h), (float)us, (float)vs, (int)((int)u), (int)((int)v), (int)texW, (int)texH);
        matrix.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void drawImage(ResourceLocation texture, MatrixStack matrix, float x, float y, float width, float height, float zLevel) {
        ScreenHelper.drawImageQuad(texture, matrix, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
    }

    public static void drawImage(MatrixStack matrix, ResourceLocation texture, float x, float y, float width, float height, float zLevel) {
        ScreenHelper.drawImageQuad(texture, matrix, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
    }

    public static void drawImage(ResourceLocation texture, MatrixStack matrix, float x, float y, float width, float height, float r, float g, float b, float a, float zLevel) {
        ScreenHelper.drawImageQuad(texture, matrix, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, zLevel);
    }

    public static void drawImage(MatrixStack matrix, ResourceLocation texture, float x, float y, float width, float height, float r, float g, float b, float a, float zLevel) {
        ScreenHelper.drawImageQuad(texture, matrix, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, zLevel);
    }

    public static void drawScaledImage(MatrixStack matrix, ResourceLocation texture, float scale, float x, float y, float width, float height, float r, float g, float b, float a, float zLevel) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)y, 0.0);
        matrix.func_227862_a_(scale, scale, 1.0f);
        ScreenHelper.drawImageQuad(texture, matrix, 0.0f, 0.0f, width, height, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, zLevel);
        matrix.func_227865_b_();
    }

    public static void drawSquashedString(MatrixStack matrix, FontRenderer fr, String text, boolean unicode, float widthFactor, float x, float y, int color, boolean shadow) {
        matrix.func_227860_a_();
        Minecraft.func_71410_x().func_238209_b_(unicode);
        float nameSize = fr.func_78256_a(text);
        boolean offset = false;
        nameSize -= (float)offset;
        if (nameSize > widthFactor) {
            float scaleFactor = widthFactor / nameSize;
            matrix.func_227861_a_((double)x, 0.0, 0.0);
            matrix.func_227862_a_(scaleFactor, 1.0f, 1.0f);
            matrix.func_227861_a_((double)(-x), 0.0, 0.0);
        }
        if (shadow) {
            fr.func_238405_a_(matrix, text, x, y, color);
        } else {
            fr.func_238421_b_(matrix, text, x, y, color);
        }
        matrix.func_227865_b_();
        Minecraft.func_71410_x().func_238209_b_(false);
    }

    public static void drawSquashedString(MatrixStack matrix, FontRenderer fr, ITextComponent text, boolean unicode, float widthFactor, float x, float y, int color, boolean shadow) {
        matrix.func_227860_a_();
        Minecraft.func_71410_x().func_238209_b_(unicode);
        float nameSize = fr.func_238414_a_((ITextProperties)text);
        boolean offset = false;
        nameSize -= (float)offset;
        if (nameSize > widthFactor) {
            float scaleFactor = widthFactor / nameSize;
            matrix.func_227861_a_((double)x, 0.0, 0.0);
            matrix.func_227862_a_(scaleFactor, 1.0f, 1.0f);
            matrix.func_227861_a_((double)(-x), 0.0, 0.0);
        }
        if (shadow) {
            fr.func_243246_a(matrix, text, x, y, color);
        } else {
            fr.func_243248_b(matrix, text, x, y, color);
        }
        matrix.func_227865_b_();
        Minecraft.func_71410_x().func_238209_b_(false);
    }

    public static void drawCenteredSquashedString(MatrixStack matrix, String text, boolean unicode, double widthFactor, int x, int y, int color, boolean shadow) {
        ScreenHelper.drawCenteredSquashedString(matrix, Minecraft.func_71410_x().field_71466_p, text, unicode, widthFactor, x, y, color, shadow);
    }

    public static void drawCenteredSquashedString(MatrixStack matrix, FontRenderer fr, String text, boolean unicode, double widthFactor, int x, int y, int color, boolean shadow) {
        matrix.func_227860_a_();
        double nameSize = fr.func_78256_a(text);
        boolean offset = false;
        nameSize -= (double)offset;
        if (nameSize > widthFactor) {
            float scaleFactor = (float)(widthFactor / nameSize);
            matrix.func_227861_a_((double)x, 0.0, 0.0);
            matrix.func_227862_a_(scaleFactor, 1.0f, 1.0f);
            matrix.func_227861_a_((double)(-x), 0.0, 0.0);
        }
        matrix.func_227861_a_(-nameSize / 2.0, 0.0, 0.0);
        ScreenHelper.drawString(matrix, text, x, (float)y, color, shadow, unicode);
        matrix.func_227865_b_();
    }

    public static void bindPokemonSprite(Pokemon pokemon, Minecraft mc) {
        mc.func_110434_K().func_110577_a(pokemon.getSprite());
    }

    public static ResourceLocation getPokemonSprite(PixelmonClientData pokemon, Minecraft mc) {
        if (pokemon == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        Stats form = pokemon.species.getForm(pokemon.form);
        if (form == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        GenderProperties genderProperties = form.getGenderProperties(pokemon.getGender());
        if (genderProperties == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        PaletteProperties currentPalette = genderProperties.getPalette(pokemon.palette);
        PaletteProperties palette = pokemon.mega || pokemon.dynamax == 2 ? (currentPalette != null ? currentPalette : genderProperties.getDefaultPalette()) : currentPalette;
        if (palette == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        ResourceLocation sprite = palette.getSprite();
        if (sprite == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        return sprite;
    }

    public static ResourceLocation getPokemonSprite(Species species, String form, Gender gender, String palette, int eggCycles, Minecraft mc) {
        if (eggCycles > 0) {
            return Resources.getEggSprite(species, eggCycles);
        }
        return species.getForm(form).getGenderProperties(gender).getPalette(palette).getSprite();
    }

    public static ResourceLocation getPokemonSprite(PokemonSpecification spec, Minecraft mc) {
        PaletteProperties foundPalette;
        GenderProperties genderProperties;
        Species species = spec.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO).getValueUnsafe();
        if (species == null) {
            return Resources.egg;
        }
        String form = spec.getValue(FormRequirement.class).orElse(species.getDefaultForm().getName());
        if (spec.getValue(EggRequirement.class).orElse(false).booleanValue()) {
            return Resources.getEggSprite(species, species.getForm(form).getEggCycles());
        }
        Gender gender = spec.getValue(GenderRequirement.class).orElse(Gender.MALE);
        String palette = spec.getValue(PaletteRequirement.class).orElse("none");
        Stats foundForm = species.getForm(form);
        if (foundForm == null) {
            foundForm = species.getDefaultForm();
        }
        if ((genderProperties = foundForm.getGenderProperties(gender)) == null) {
            genderProperties = foundForm.getDefaultGenderProperties();
        }
        if ((foundPalette = genderProperties.getPalette(palette)) == null) {
            foundPalette = genderProperties.getDefaultPalette();
        }
        return foundPalette.getSprite();
    }

    public static void drawScoreboard(MatrixStack matrix, int top, ScoreboardJustification justification, int x, int alpha, String title, Collection<String> lines, Collection<String> scores) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int tempWidth = ScreenHelper.getLongestStringWidth(lines);
        if (scores != null) {
            tempWidth += ScreenHelper.getLongestStringWidth(scores) + 20;
        }
        if (fontRenderer.func_78256_a(title) > tempWidth) {
            tempWidth = fontRenderer.func_78256_a(title);
        }
        int justifiedWidth = justification == ScoreboardJustification.RIGHT ? tempWidth : (justification == ScoreboardJustification.CENTER ? tempWidth / 2 : 0);
        int left = x - justifiedWidth - 3;
        int boxHeight = (lines.size() + 1) * 10;
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)left, (int)top, (int)(left + tempWidth), (int)(top + boxHeight), (int)alpha);
        ScreenHelper.drawCenteredString(matrix, title, (float)left + (float)tempWidth / 2.0f, (float)top, -1);
        int y = top;
        for (String line : lines) {
            fontRenderer.func_238405_a_(matrix, line, (float)(left + 3), (float)(y += 10), -1);
        }
        y = top;
        if (scores != null) {
            for (String line : scores) {
                fontRenderer.func_238405_a_(matrix, line, (float)(left + tempWidth - 3 - fontRenderer.func_78256_a(line)), (float)(y += 10), -1);
            }
        }
    }

    public static int getLongestStringWidth(Collection<String> lines) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int longestStringWidth = 0;
        for (String line : lines) {
            int currentStringWidth = fontRenderer.func_78256_a(line);
            if (currentStringWidth <= longestStringWidth) continue;
            longestStringWidth = currentStringWidth;
        }
        return longestStringWidth;
    }

    public static int getLongestWidth(Collection<ITextComponent> lines) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int longestStringWidth = 0;
        for (ITextComponent line : lines) {
            int currentStringWidth = fontRenderer.func_238414_a_((ITextProperties)line);
            if (currentStringWidth <= longestStringWidth) continue;
            longestStringWidth = currentStringWidth;
        }
        return longestStringWidth;
    }

    public static String[] trimStringToWidth(FontRenderer fr, String string, int width) {
        ArrayList<String> strings = new ArrayList<String>();
        while (!string.isEmpty()) {
            String line = fr.func_238412_a_(string, width);
            strings.add(line);
            string = string.substring(line.length());
        }
        return strings.toArray(new String[0]);
    }

    public static Optional<int[]> renderTooltip(MatrixStack matrix, int x, int y, int gradient1, int background, int alpha, boolean centerBox, boolean centerText, String ... tooltipData) {
        Collection tooltipCollection = Arrays.stream(tooltipData).map(TextHelper::colour).collect(Collectors.toList());
        return ScreenHelper.renderTooltip(matrix, x, y, tooltipCollection, gradient1, background, alpha, centerBox, centerText);
    }

    public static Optional<int[]> renderTooltip(MatrixStack matrix, int x, int y, Collection<ITextComponent> tooltipData, int gradient1, int background, int alpha, boolean centerBox, boolean centerText, float zLevel) {
        if (tooltipData.isEmpty()) {
            return Optional.empty();
        }
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int longestStringWidth = ScreenHelper.getLongestWidth(tooltipData);
        int left = x;
        int top = y;
        if (centerBox) {
            left -= longestStringWidth / 2;
        }
        int boxHeight = 8;
        if (tooltipData.size() > 1) {
            boxHeight += (tooltipData.size() - 1) * 10;
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.0, 1.0);
        background = background & 0xFFFFFF | alpha << 24;
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(left - 3), (int)(top - 4), (int)(left + longestStringWidth + 3), (int)(top - 3), (int)background);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(left - 3), (int)(top + boxHeight + 3), (int)(left + longestStringWidth + 3), (int)(top + boxHeight + 4), (int)background);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(left - 3), (int)(top - 3), (int)(left + longestStringWidth + 3), (int)(top + boxHeight + 3), (int)background);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(left - 4), (int)(top - 3), (int)(left - 3), (int)(top + boxHeight + 3), (int)background);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(left + longestStringWidth + 3), (int)(top - 3), (int)(left + longestStringWidth + 4), (int)(top + boxHeight + 3), (int)background);
        int gradient2 = (gradient1 & 0xFFFFFF) >> 1 | gradient1 & 0xFF000000;
        ScreenHelper.drawGradientRect(matrix, left - 3, top - 3 + 1, zLevel, left - 3 + 1, top + boxHeight + 3 - 1, gradient1, gradient2);
        ScreenHelper.drawGradientRect(matrix, left + longestStringWidth + 2, top - 3 + 1, zLevel, left + longestStringWidth + 3, top + boxHeight + 3 - 1, gradient1, gradient2);
        ScreenHelper.drawGradientRect(matrix, left - 3, top - 3, zLevel, left + longestStringWidth + 3, top - 3 + 1, gradient1, gradient1);
        ScreenHelper.drawGradientRect(matrix, left - 3, top + boxHeight + 2, zLevel, left + longestStringWidth + 3, top + boxHeight + 3, gradient2, gradient2);
        for (ITextComponent line : tooltipData) {
            if (!centerText) {
                fontRenderer.func_243246_a(matrix, line, (float)left, (float)top, -1);
            } else {
                ScreenHelper.drawCentered(matrix, line, (float)left + (float)longestStringWidth / 2.0f, top, -1, false);
            }
            top += 10;
        }
        matrix.func_227865_b_();
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        return Optional.of(new int[]{left - 4, top - 4, left + longestStringWidth + 4, top + boxHeight + 4});
    }

    public static Optional<int[]> renderTooltip(MatrixStack matrix, int x, int y, Collection<ITextComponent> tooltipData, int gradient1, int background, int alpha, boolean centerBox, boolean centerText) {
        return ScreenHelper.renderTooltip(matrix, x, y, tooltipData, gradient1, background, alpha, centerBox, centerText, 300.0f);
    }

    public static void drawString(MatrixStack matrix, String text, float x, float y, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_238421_b_(matrix, text, x, y, color);
    }

    public static int getStringWidth(String text) {
        return ScreenHelper.getStringWidth(text, false);
    }

    public static int getStringWidth(String text, boolean unicode) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontRenderer.func_78256_a(text);
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
        return width;
    }

    public static int getStringWidth(ITextComponent text, boolean unicode) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontRenderer.func_238414_a_((ITextProperties)text);
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
        return width;
    }

    public static void drawCenteredString(MatrixStack matrix, String text, float x, float y, int color) {
        ScreenHelper.drawCenteredString(matrix, text, x, y, color, false);
    }

    public static void drawCenteredString(MatrixStack matrix, String text, float x, float y, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ScreenHelper.drawCenteredString(matrix, fontRenderer, text, x, y, color, dropShadow);
    }

    public static void drawCenteredString(MatrixStack matrix, ITextComponent text, float x, float y, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ScreenHelper.drawCenteredString(matrix, fontRenderer, text, x, y, color, dropShadow);
    }

    public static void drawCenteredString(MatrixStack matrix, FontRenderer fontRenderer, String text, float x, float y, int color, boolean dropShadow) {
        if (dropShadow) {
            fontRenderer.func_238405_a_(matrix, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
        } else {
            fontRenderer.func_238421_b_(matrix, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
        }
    }

    public static void drawCenteredString(MatrixStack matrix, ITextComponent text, float x, float y, int color) {
        ScreenHelper.drawCenteredString(matrix, text, x, y, color, false);
    }

    public static void drawCenteredString(MatrixStack matrix, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color, boolean dropShadow) {
        if (dropShadow) {
            fontRenderer.func_243246_a(matrix, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
        } else {
            fontRenderer.func_243248_b(matrix, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
        }
    }

    public static void drawCentered(MatrixStack matrix, ITextComponent text, float x, float y, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ScreenHelper.drawCentered(matrix, fontRenderer, text, x, y, color, dropShadow);
    }

    public static void drawCentered(MatrixStack matrix, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color, boolean dropShadow) {
        if (dropShadow) {
            fontRenderer.func_243246_a(matrix, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
        } else {
            fontRenderer.func_243248_b(matrix, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
        }
    }

    public static void drawCenteredSplitString(MatrixStack matrix, String text, float x, float y, int maxLength, int color) {
        ScreenHelper.drawCenteredSplitString(matrix, text, x, y, maxLength, color, true);
    }

    public static void drawCenteredSplitString(MatrixStack matrix, String text, float x, float y, int maxLength, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = fontRenderer.func_78256_a(text);
        int numLines = Math.max(1, (int)Math.ceil((float)textWidth / (float)maxLength));
        int lineWidth = text.length() / numLines;
        ArrayList<String> splitStrings = new ArrayList<String>(numLines);
        int lastIndex = 0;
        for (int i = 0; i < numLines - 1; ++i) {
            int spaceIndex = text.indexOf(" ", lastIndex + lineWidth);
            if (spaceIndex <= -1) continue;
            splitStrings.add(text.substring(lastIndex, spaceIndex + 1));
            lastIndex = spaceIndex + 1;
        }
        if (lastIndex < text.length()) {
            splitStrings.add(text.substring(lastIndex));
        }
        numLines = splitStrings.size();
        int currentY = (int)y - 6 * (numLines - 1);
        for (int i = 0; i < numLines; ++i) {
            ScreenHelper.drawCenteredString(matrix, (String)splitStrings.get(i), x, (float)currentY, color, dropShadow);
            currentY += 12;
        }
    }

    public static void drawCenteredLimitedString(MatrixStack matrix, String text, float x, float y, int maxLength, int color) {
        ScreenHelper.drawCenteredString(matrix, ScreenHelper.getLimitedString(text, maxLength), x, y, color, true);
    }

    public static String getLimitedString(String text, int maxLength) {
        String ellipses = "...";
        if (maxLength <= 3) {
            return ellipses;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textLength = text.length();
        String drawText = text;
        if (textLength >= 4) {
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fontRenderer.func_78256_a(String.valueOf(text.charAt(i)))) <= maxLength) continue;
                drawText = text.substring(0, i - 3) + ellipses;
                break;
            }
        }
        return drawText;
    }

    public static List<String> splitString(String text, int maxLength) {
        return ScreenHelper.splitString(text, maxLength, false);
    }

    public static List<String> splitString(String text, int maxLength, boolean unicode) {
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        ArrayList<String> splitString = new ArrayList<String>();
        if (text.isEmpty()) {
            splitString.add("");
        } else {
            String[] lines;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (String line : lines = text.split("\n")) {
                String s = fontRenderer.func_238413_a_(line, maxLength, false);
                while (ScreenHelper.getStringWidth(line) > maxLength) {
                    splitString.add(s);
                    line = line.substring(s.length());
                    s = fontRenderer.func_238413_a_(line, maxLength, false);
                }
                splitString.add(s);
            }
        }
        if (unicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
        return splitString;
    }

    public static String removeNewLine(String string) {
        int length = string.length();
        if (length > 0 && string.charAt(length - 1) == '\n') {
            return string.substring(0, length - 1);
        }
        return string;
    }

    public static void drawGradientRect(MatrixStack matrix, int left, int top, float zLevel, int right, int bottom, int startColour, int endColour) {
        ScreenHelper.drawGradientRect(matrix, left, top, zLevel, right, bottom, startColour, endColour, false);
    }

    public static void drawGradientRect(MatrixStack matrix, int left, int top, float zLevel, int right, int bottom, int startColour, int endColour, boolean horizontal) {
        float startAlpha = (float)(startColour >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColour >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColour >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColour & 0xFF) / 255.0f;
        float endAlpha = (float)(endColour >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColour >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColour >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColour & 0xFF) / 255.0f;
        ScreenHelper.drawGradientRect(matrix, left, top, zLevel, right, bottom, new Vector4f(startRed, startGreen, startBlue, startAlpha), new Vector4f(endRed, endGreen, endBlue, endAlpha), horizontal);
    }

    public static void drawGradientRect(MatrixStack matrix, int left, int top, float zLevel, int right, int bottom, Vector4f startColour, Vector4f endColour, boolean horizontal) {
        float startAlpha = startColour.func_195915_d();
        float startRed = startColour.func_195910_a();
        float startGreen = startColour.func_195913_b();
        float startBlue = startColour.func_195914_c();
        float endAlpha = endColour.func_195915_d();
        float endRed = endColour.func_195910_a();
        float endGreen = endColour.func_195913_b();
        float endBlue = endColour.func_195914_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.shadeModel((int)7425);
        matrix.func_227860_a_();
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(mat, (float)left, (float)top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        if (horizontal) {
            buffer.func_227888_a_(mat, (float)left, (float)bottom, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        } else {
            buffer.func_227888_a_(mat, (float)left, (float)bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        }
        buffer.func_227888_a_(mat, (float)right, (float)bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        if (horizontal) {
            buffer.func_227888_a_(mat, (float)right, (float)top, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        } else {
            buffer.func_227888_a_(mat, (float)right, (float)top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        matrix.func_227865_b_();
    }

    public static void drawBar(MatrixStack matrix, double x, double y, double width, double height, float percent, Color color) {
        ScreenHelper.drawBar(matrix, x, y, width, height, percent, color, false);
    }

    public static void drawBar(MatrixStack matrix, double x, double y, double width, double height, float percent, Color color, boolean flip) {
        ScreenHelper.drawBar(matrix, x, y, width, height, percent, color, Color.GRAY, flip);
    }

    public static void drawBar(MatrixStack matrix, double x, double y, double width, double height, float percent, Color color, Color incomplete, boolean flip) {
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        matrix.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        double barWidth = width - 6.0;
        buffer.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_225586_a_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_227888_a_(mat, (float)x, (float)(y + height), 0.0f).func_225586_a_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_227888_a_(mat, (float)(x + barWidth), (float)(y + height), 0.0f).func_225586_a_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_227888_a_(mat, (float)(x + barWidth), (float)y, 0.0f).func_225586_a_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).func_181675_d();
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        float curWidth = (float)((double)percent * barWidth);
        if (flip) {
            buffer.func_227888_a_(mat, (float)(x + (barWidth - (double)curWidth)), (float)y, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_227888_a_(mat, (float)(x + (barWidth - (double)curWidth)), (float)(y + height), 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_227888_a_(mat, (float)(x + barWidth), (float)(y + height), 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_227888_a_(mat, (float)(x + barWidth), (float)y, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        } else {
            buffer.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_227888_a_(mat, (float)x, (float)(y + height), 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_227888_a_(mat, (float)(x + (double)curWidth), (float)(y + height), 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_227888_a_(mat, (float)(x + (double)curWidth), (float)y, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        }
        tessellator.func_78381_a();
        matrix.func_227865_b_();
        RenderSystem.enableTexture();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableColorMaterial();
    }

    public static void drawRectWithSemicircleEnds(MatrixStack matrix, double x, double y, double z, double w, double h, int segments, Color color) {
        ScreenHelper.prepareSmoothDrawing(matrix);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        double segment = Math.PI / (double)segments;
        double rad = h / 2.0;
        matrix.func_227861_a_(x, y, z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        for (int pass = 1; pass <= 2; ++pass) {
            double dy;
            double dx;
            int i;
            if (pass == 2 && color == Color.WHITE) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                RenderSystem.blendFunc((int)770, (int)771);
            }
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= segments; ++i) {
                dx = -Math.sin(segment * (double)i) * rad;
                dy = Math.cos(segment * (double)i) * rad;
                buffer.func_227888_a_(mat, (float)dx, (float)(dy + rad), 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= segments; ++i) {
                dx = Math.sin(segment * (double)i) * rad;
                dy = Math.cos(segment * (double)i) * rad;
                buffer.func_227888_a_(mat, (float)(w + dx), (float)(dy + rad), 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(mat, (float)w, 0.0f, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(mat, (float)w, (float)h, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(mat, 0.0f, (float)h, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            tessellator.func_78381_a();
        }
        ScreenHelper.endSmoothDrawing(matrix);
    }

    public static void drawCircle(MatrixStack matrix, double x, double y, double z, double d, int segments, Color color) {
        ScreenHelper.drawEllipse(matrix, x, y, z, d, d, segments, color);
    }

    public static void drawEllipse(MatrixStack matrix, double x, double y, double z, double w, double h, int segments, Color color) {
        ScreenHelper.prepareSmoothDrawing(matrix);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        double segment = Math.PI * 2 / (double)segments;
        double wr = w / 2.0;
        double hr = h / 2.0;
        matrix.func_227861_a_(x, y, z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2 && color == Color.WHITE) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                RenderSystem.blendFunc((int)770, (int)771);
            }
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            for (int i = 0; i <= segments; ++i) {
                double dx = Math.sin(segment * (double)i) * wr;
                double dy = Math.cos(segment * (double)i) * hr;
                buffer.func_227888_a_(mat, (float)(dx + wr), (float)(dy + hr), 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        ScreenHelper.endSmoothDrawing(matrix);
    }

    public static void drawQuad(MatrixStack matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2 && color == Color.WHITE) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                RenderSystem.blendFunc((int)770, (int)771);
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(mat, x1, y1, z1).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(mat, x2, y2, z2).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(mat, x3, y3, z3).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(mat, x4, y4, z4).func_227885_a_(r, g, b, a).func_181675_d();
            tessellator.func_78381_a();
        }
        RenderSystem.enableTexture();
    }

    public static void prepareSmoothDrawing(MatrixStack matrix) {
        matrix.func_227860_a_();
        GL11.glEnable((int)2881);
        GL11.glHint((int)3155, (int)4354);
        RenderSystem.disableCull();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
    }

    public static void endSmoothDrawing(MatrixStack matrix) {
        GL11.glDisable((int)2881);
        RenderSystem.enableTexture();
        matrix.func_227865_b_();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void drawEntity(MatrixStack matrix, LivingEntity ent, int x, int y, float scale, float rotationYaw, float rotationPitch) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)y, 50.0);
        matrix.func_227862_a_(-scale, scale, scale);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        float f2 = ent.field_70761_aq;
        float f3 = ent.field_70177_z;
        float f4 = ent.field_70125_A;
        float f5 = ent.field_70758_at;
        float f6 = ent.field_70759_as;
        RenderHelper.func_227780_a_();
        matrix.func_227863_a_(QuaternionHelper.fromEuler(-(rotationPitch / 40.0f) * 20.0f, 1.0f, 0.0f, 0.0f));
        ent.field_70761_aq = rotationYaw / 40.0f * 20.0f;
        ent.field_70177_z = rotationYaw / 40.0f * 20.0f;
        ent.field_70125_A = -(rotationPitch / 40.0f) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        matrix.func_227861_a_(0.0, (double)((float)ent.func_70033_W()), 0.0);
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.field_217783_c.setAnglesInternal(180.0f, 0.0f);
        renderManager.func_178633_a(false);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> renderManager.func_229084_a_((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (IRenderTypeBuffer)buffer, 0xF000F0));
        buffer.func_228461_a_();
        renderManager.func_178633_a(true);
        ent.field_70761_aq = f2;
        ent.field_70177_z = f3;
        ent.field_70125_A = f4;
        ent.field_70758_at = f5;
        ent.field_70759_as = f6;
        matrix.func_227865_b_();
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
    }

    public static void drawPokemonInfoChooseMove(MatrixStack matrix, PixelmonClientData pokemon, int width, int height, float zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        ScreenHelper.drawImageQuad(ScreenHelper.getPokemonSprite(pokemon, mc), matrix, (float)width / 2.0f - 114.0f, (float)height / 2.0f - 76.0f, 64.0f, 64.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        ScreenHelper.drawCenteredString(matrix, pokemon.getDisplayName(), (float)width / 2.0f - 82.0f, (float)height / 2.0f + 8.0f, 0xFFFFFF);
        Element type1 = pokemon.getBaseStats().getTypes().get(0);
        Element type2 = pokemon.getBaseStats().getTypes().size() > 1 ? pokemon.getBaseStats().getTypes().get(1) : null;
        float x = type1.textureX;
        float y = type1.textureY;
        float x1 = 0.0f;
        float y1 = 0.0f;
        if (pokemon.getBaseStats().getTypes().size() > 1) {
            x1 = type2.textureX;
            y1 = type2.textureY;
        }
        if (type2 != null && type2 != Element.MYSTERY) {
            ScreenHelper.drawImageQuadUV(Resources.types, matrix, (float)width / 2.0f - 83.0f, (float)height / 2.0f - 84.0f, 21.0f, 21.0f, x1, y1, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
            ScreenHelper.drawImageQuadUV(Resources.types, matrix, (float)width / 2.0f - 107.0f, (float)height / 2.0f - 84.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        } else {
            ScreenHelper.drawImageQuadUV(Resources.types, matrix, (float)width / 2.0f - 93.0f, (float)height / 2.0f - 84.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        }
        mc.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.level, (float)width / 2.0f - 80.0f, (float)height / 2.0f - 94.0f, 0xFFFFFF);
        mc.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + pokemon.getDexNumber(), (float)width / 2.0f - 122.0f, (float)height / 2.0f - 94.0f, 0xFFFFFF);
    }

    public static void closeScreen() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    public static void switchFocus(int keyInt, List<TextFieldWidget> textFields) {
        TextFieldWidget[] textFieldArray = new TextFieldWidget[textFields.size()];
        ScreenHelper.switchFocus(keyInt, textFields.toArray(textFieldArray));
    }

    public static void switchFocus(int keyInt, TextFieldWidget ... textFields) {
        if (keyInt == 258) {
            for (int i = 0; i < textFields.length; ++i) {
                TextFieldWidget textField = textFields[i];
                if (!textField.func_230999_j_()) continue;
                textField.func_146195_b(false);
                textFields[(i + 1) % textFields.length].func_146195_b(true);
                return;
            }
            textFields[0].func_146195_b(true);
        }
    }

    public static void drawAttackInfoBox(MatrixStack matrix, float zLevel, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(Resources.cwPanel);
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)width / 2.0f + 100.0f, (float)height / 2.0f - 90.0f, 100.0f, 140.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.75f, zLevel);
        String text = I18n.func_135052_a((String)"gui.choosemoveset.attackdetails", (Object[])new Object[0]);
        mc.field_71466_p.func_238421_b_(matrix, text, (float)(width + 150) - (float)mc.field_71466_p.func_78256_a(text) / 2.0f, (float)(height - 92), 0);
    }

    public static void drawAttackInfoList(MatrixStack matrix, Attack a, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int y = height / 2 - 85;
        int x = width / 2 + 105;
        String powerString = I18n.func_135052_a((String)"gui.choosemoveset.power", (Object[])new Object[0]) + ": ";
        powerString = a.getMove().getBasePower() > 0 ? powerString + a.getMove().getBasePower() : powerString + "--";
        fontRenderer.func_238421_b_(matrix, powerString, (float)x, (float)(y + 3), 0);
        String accuracyString = I18n.func_135052_a((String)"gui.battle.accuracy", (Object[])new Object[0]) + ": ";
        accuracyString = a.getMove().getAccuracy() > 0 ? accuracyString + a.getMove().getAccuracy() : accuracyString + "--";
        fontRenderer.func_238421_b_(matrix, accuracyString, (float)x, (float)(y + 13), 0);
        fontRenderer.func_238421_b_(matrix, I18n.func_135052_a((String)"nbt.pp", (Object[])new Object[0]) + " " + a.pp + "/" + a.getMaxPP(), (float)x, (float)(y + 23), 0);
        String typeString = I18n.func_135052_a((String)"gui.battle.type", (Object[])new Object[0]) + " ";
        fontRenderer.func_238421_b_(matrix, typeString, (float)x, (float)(y + 33), 0);
        fontRenderer.func_238421_b_(matrix, a.getMove().getAttackType().getLocalizedName(), (float)(x + fontRenderer.func_78256_a(typeString)), (float)(y + 33), a.getMove().getAttackType().getColor());
        String category = a.getMove().getAttackCategory().getLocalizedName();
        fontRenderer.func_238421_b_(matrix, category, (float)x, (float)(y + 43), 0);
        ScreenHelper.drawSplitString(matrix, I18n.func_135052_a((String)("attack." + a.getMove().getAttackName().replace(" ", "_").toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]), x, y + 58, 95, 0);
    }

    public static void drawSplitString(MatrixStack matrix, String text, int x, int y, int maxLength, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        for (IReorderingProcessor ireorderingprocessor : fontRenderer.func_238425_b_((ITextProperties)new StringTextComponent(text), maxLength)) {
            fontRenderer.func_238415_a_(ireorderingprocessor, (float)x, (float)y, color, mat, false);
            y += 9;
        }
    }

    public static void drawSplitString(MatrixStack matrix, ITextComponent text, int x, int y, int maxLength, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        for (IReorderingProcessor ireorderingprocessor : fontRenderer.func_238425_b_((ITextProperties)text, maxLength)) {
            fontRenderer.func_238415_a_(ireorderingprocessor, (float)x, (float)y, color, mat, false);
            y += 9;
        }
    }

    public static void drawAttackInfoMoveset(MatrixStack matrix, Attack attack, int y, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.replaceattack.power", (Object[])new Object[0]), (float)width / 2.0f - 120.0f, (float)height / 2.0f + 60.0f, 0xFFFFFF);
        fontRenderer.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.replaceattack.accuracy", (Object[])new Object[0]), (float)width / 2.0f - 120.0f, (float)height / 2.0f + 70.0f, 0xFFFFFF);
        int bpextra = 0;
        int acextra = 0;
        if (attack.getMove().getBasePower() >= 100) {
            bpextra = fontRenderer.func_78256_a("0");
        }
        if (attack.getMove().getAccuracy() >= 100) {
            acextra = fontRenderer.func_78256_a("0");
        }
        String powerString = attack.getMove().getBasePower() > 0 ? "" + attack.getMove().getBasePower() : "--";
        fontRenderer.func_238421_b_(matrix, powerString, (float)width / 2.0f - 60.0f - (float)bpextra, (float)height / 2.0f + 60.0f, 0xFFFFFF);
        String accuracyString = attack.getMove().getAccuracy() > 0 ? "" + attack.getMove().getAccuracy() : "--";
        fontRenderer.func_238421_b_(matrix, accuracyString, (float)width / 2.0f - 60.0f - (float)acextra, (float)height / 2.0f + 70.0f, 0xFFFFFF);
        fontRenderer.func_238421_b_(matrix, attack.getMove().getAttackCategory() == null ? "" : attack.getMove().getAttackCategory().getLocalizedName(), (float)width / 2.0f - 120.0f, (float)height / 2.0f + 80.0f, 0xFFFFFF);
        ScreenHelper.drawSplitString(matrix, I18n.func_135052_a((String)("attack." + attack.getMove().getAttackName().toLowerCase(Locale.ROOT).replace(" ", "_") + ".description"), (Object[])new Object[0]), width / 2 - 20, y, 135, 0xFFFFFF);
    }

    public static void drawMoveset(MatrixStack matrix, Moveset moveset, int width, int height, float zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < moveset.size(); ++i) {
            Attack move = moveset.get(i);
            mc.field_71466_p.func_238421_b_(matrix, move.getMove().getLocalizedName(), (float)width / 2.0f + 11.0f, (float)height / 2.0f - 85.0f + (float)(22 * i), 0xFFFFFF);
            mc.field_71466_p.func_238421_b_(matrix, move.pp + "/" + move.getMaxPP(), (float)width / 2.0f + 90.0f, (float)height / 2.0f - 83.0f + (float)(22 * i), 0xFFFFFF);
            float x = move.getMove().getAttackType().textureX;
            float y = move.getMove().getAttackType().textureY;
            ScreenHelper.drawImageQuadUV(Resources.types, matrix, (float)width / 2.0f - 23.0f, (float)height / 2.0f - 92.0f + (float)(22 * i), 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        }
    }

    public static int toColourValue(float red, float green, float blue, float alpha) {
        int r = (int)(red * 255.0f) & 0xFF;
        int g = (int)(green * 255.0f) & 0xFF;
        int b = (int)(blue * 255.0f) & 0xFF;
        int a = (int)(alpha * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (b << 8) + g;
    }

    public static PixelmonEntity getEntity(UUID pokemonUUID) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            for (Entity e : mc.field_71441_e.func_217416_b()) {
                PixelmonEntity pokemon;
                if (!(e instanceof PixelmonEntity) || !(pokemon = (PixelmonEntity)e).getPokemon().getUUID().equals(pokemonUUID)) continue;
                return pokemon;
            }
        }
        return null;
    }

    public static void drawDialogueBox(MatrixStack matrix, Screen screen, String name, List<String> chatText, float zLevel) {
        ScreenHelper.drawDialogueBox(matrix, screen, name, String.join((CharSequence)"\n", chatText), zLevel);
    }

    public static void drawDialogueBox(MatrixStack matrix, Screen screen, ITextComponent name, ITextComponent chatText, float zLevel) {
        ScreenHelper.drawDialogueBox(matrix, screen, name.getString(), chatText.getString(), zLevel);
    }

    public static void drawDialogueBox(MatrixStack matrix, Screen screen, String name, String chatText, float zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        ScreenHelper.drawImageQuad(Resources.evo, matrix, (float)screen.field_230708_k_ / 2.0f - 120.0f, (float)screen.field_230709_l_ / 4.0f - 40.0f, 240.0f, 80.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        mc.field_71466_p.func_238405_a_(matrix, TextFormatting.BOLD + name, (float)screen.field_230708_k_ / 2.0f - 107.0f, (float)screen.field_230709_l_ / 4.0f - 32.0f, 0xFFFFFF);
        ScreenHelper.drawCenteredSplitString(matrix, chatText, (float)screen.field_230708_k_ / 2.0f, (float)screen.field_230709_l_ / 4.0f - 2.0f, 200, 0xFFFFFF, false);
    }

    public static void drawBattleTimer(MatrixStack matrix, Screen gui, int time) {
        Minecraft mc = Minecraft.func_71410_x();
        time = Math.max(time, 0);
        String timerString = I18n.func_135052_a((String)"battlecontroller.afktimer", (Object[])new Object[0]) + time;
        int color = time <= 5 ? 0xFF0000 : 0xFFFFFF;
        AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)mc.field_71466_p, (String)timerString, (int)(gui.field_230708_k_ - mc.field_71466_p.func_78256_a(timerString) - 5), (int)5, (int)color);
    }

    public static void drawPokemonHoverInfo(MatrixStack matrix, Pokemon pokemon, int x, int y) {
        if (pokemon == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (x - 104 < 0) {
            x = 104;
        }
        int addition = 0;
        if (!pokemon.isEgg()) {
            if (pokemon.getForm() != null && !pokemon.getForm().isForm(PixelmonForms.NONE)) {
                addition += 10;
            }
            if (!pokemon.isDefaultPalette()) {
                addition += 10;
            }
        }
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(x - 104), (int)(y - 2), (int)(x + 2), (int)(y + 20 + addition), (int)-1437248170);
        String name = pokemon.getDisplayName();
        mc.field_71466_p.func_238421_b_(matrix, name, (float)(x - 102), (float)y, 0xFFFFFF);
        mc.func_110434_K().func_110577_a(Resources.pixelmonOverlay);
        if (!pokemon.isEgg()) {
            if (pokemon.getGender() != Gender.NONE) {
                ResourceLocation rl = null;
                if (pokemon.getGender() == Gender.MALE) {
                    rl = Resources.male;
                } else if (pokemon.getGender() == Gender.FEMALE) {
                    rl = Resources.female;
                }
                if (rl != null) {
                    ScreenHelper.drawImageQuad(rl, matrix, mc.field_71466_p.func_78256_a(name) + x - 101, y, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
            int y2 = y;
            if (!pokemon.getForm().isForm(PixelmonForms.NONE)) {
                FontRenderer fontRenderer = mc.field_71466_p;
                String string = I18n.func_135052_a((String)"gui.screenpokechecker.form", (Object[])new Object[]{I18n.func_135052_a((String)pokemon.getForm().getTranslationKey(), (Object[])new Object[0])});
                float f = x - 102;
                mc.field_71466_p.getClass();
                fontRenderer.func_238421_b_(matrix, string, f, (float)(y2 + 9), 0xFFFFFF);
                mc.field_71466_p.getClass();
                y2 += 9;
            }
            if (!pokemon.isDefaultPalette() && pokemon.getPalette() != null) {
                FontRenderer fontRenderer = mc.field_71466_p;
                String string = I18n.func_135052_a((String)"gui.screenpokechecker.palette", (Object[])new Object[]{pokemon.getPalette().getTranslatedName().getString()});
                float f = x - 102;
                mc.field_71466_p.getClass();
                fontRenderer.func_238421_b_(matrix, string, f, (float)(y2 + 9), 0xFFFFFF);
                mc.field_71466_p.getClass();
                y2 += 9;
            }
            String level = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
            FontRenderer fontRenderer = mc.field_71466_p;
            float f = x - 101;
            mc.field_71466_p.getClass();
            fontRenderer.func_238421_b_(matrix, level, f, (float)(y2 + 9 + 1), 0xFFFFFF);
            String health = pokemon.getHealth() > 0 ? I18n.func_135052_a((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth() : I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
            FontRenderer fontRenderer2 = mc.field_71466_p;
            float f2 = x - 97 + mc.field_71466_p.func_78256_a(level);
            mc.field_71466_p.getClass();
            fontRenderer2.func_238421_b_(matrix, health, f2, (float)(y2 + 9 + 1), 0xFFFFFF);
            if (!pokemon.getHeldItem().func_190926_b()) {
                mc.func_175599_af().func_175042_a(pokemon.getHeldItem(), x - 16, y - 1);
            }
        }
    }

    public static void drawScaledCenteredSplitString(MatrixStack matrix, String text, float x, float y, int color, float fontSize, int maxLength, boolean dropShadow) {
        float scalar = fontSize / 16.0f;
        matrix.func_227862_a_(scalar, scalar, 1.0f);
        ScreenHelper.drawCenteredSplitString(matrix, text, x / scalar, y / scalar, maxLength, color, dropShadow);
        matrix.func_227862_a_(1.0f / scalar, 1.0f / scalar, 1.0f);
    }

    public static void drawScaledSquashedString(MatrixStack matrix, String text, float x, float y, int color, float fontSize, double widthFactor) {
        ScreenHelper.drawScaledSquashedString(matrix, text, x, y, color, fontSize, widthFactor, false);
    }

    public static void drawScaledSquashedString(MatrixStack matrix, String text, float x, float y, int color, float fontSize, double widthFactor, boolean unicode) {
        float scalar = fontSize / 16.0f;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        Minecraft.func_71410_x().func_238209_b_(unicode);
        double nameSize = fr.func_78256_a(text);
        boolean offset = false;
        nameSize -= (double)offset;
        matrix.func_227860_a_();
        if (nameSize > widthFactor) {
            float scaleFactor = (float)(widthFactor / nameSize);
            matrix.func_227861_a_((double)x, 0.0, 0.0);
            matrix.func_227862_a_(scaleFactor, 1.0f, 1.0f);
            matrix.func_227861_a_((double)(-x), 0.0, 0.0);
        }
        matrix.func_227862_a_(scalar, scalar, 1.0f);
        fr.func_238421_b_(matrix, text, (float)((int)(x / scalar)), (float)((int)(y / scalar)), color);
        Minecraft.func_71410_x().func_238209_b_(false);
        matrix.func_227865_b_();
        RenderSystem.lineWidth((float)2.0f);
    }

    public static void drawScaledCenteredSplitString(MatrixStack matrix, String text, float x, float y, int color, float fontSize, int maxLength) {
        ScreenHelper.drawScaledCenteredSplitString(matrix, text, x, y, color, fontSize, maxLength, true);
    }

    public static Screen getCurrentScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
    }

    public static IRenderTypeBuffer.Impl getBufferImpl() {
        return IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
    }

    public static void render(RenderType renderType, MatrixStack matrix, BiConsumer<MatrixStack, IVertexBuilder> toRender) {
        IRenderTypeBuffer.Impl impl = ScreenHelper.getBufferImpl();
        IVertexBuilder buffer = impl.getBuffer(renderType);
        toRender.accept(matrix, buffer);
        impl.func_228461_a_();
    }

    public static void setupOverlayRendering(MatrixStack matrix) {
        RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.ortho((double)0.0, (double)mc.func_228018_at_().func_198107_o(), (double)mc.func_228018_at_().func_198087_p(), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        matrix.func_227861_a_(0.0, 0.0, -2000.0);
    }

    public static boolean isKeyDown(int key) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key);
    }

    public static void drawBattleCursor(MatrixStack matrix, boolean draw, float x, float y, float z) {
        if (draw) {
            CursorHelper.setCursor(CursorHelper.BATTLE_CURSOR);
        } else {
            CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        }
    }

    public static void drawStar(MatrixStack matrix, double x, double y, double z, double r1, double r2, int points, boolean outline, float r, float g, float b, float a) {
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.lineWidth((float)1.0f);
        matrix.func_227860_a_();
        matrix.func_227861_a_(x, y, z);
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        float change = (float)(Math.PI * 2 / (double)(points * 2));
        float angle = -change / 2.0f;
        if (outline) {
            GL11.glEnable((int)2848);
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            for (int i = 0; i <= points * 2; ++i) {
                double radius = i % 2 == 0 ? r1 : r2;
                double dx = Math.cos(angle) * radius;
                double dy = Math.sin(angle) * radius;
                buffer.func_227888_a_(mat, (float)dx, (float)dy, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
                angle += change;
            }
            tessellator.func_78381_a();
        } else {
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
            for (int i = 0; i <= points * 2; ++i) {
                double radius = i % 2 == 0 ? r1 : r2;
                double dx = Math.cos(angle) * radius;
                double dy = Math.sin(angle) * radius;
                buffer.func_227888_a_(mat, (float)dx, (float)dy, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
                angle -= change;
            }
            tessellator.func_78381_a();
        }
        matrix.func_227865_b_();
        RenderSystem.enableTexture();
    }

    public static void fill(MatrixStack p_238467_0_, int p_238467_1_, int p_238467_2_, int p_238467_3_, int p_238467_4_, int p_238467_5_) {
        ScreenHelper.innerFill(p_238467_0_.func_227866_c_().func_227870_a_(), p_238467_1_, p_238467_2_, p_238467_3_, p_238467_4_, p_238467_5_);
    }

    private static void innerFill(Matrix4f p_238460_0_, int p_238460_1_, int p_238460_2_, int p_238460_3_, int p_238460_4_, int p_238460_5_) {
        if (p_238460_1_ < p_238460_3_) {
            int i = p_238460_1_;
            p_238460_1_ = p_238460_3_;
            p_238460_3_ = i;
        }
        if (p_238460_2_ < p_238460_4_) {
            int j = p_238460_2_;
            p_238460_2_ = p_238460_4_;
            p_238460_4_ = j;
        }
        float f3 = (float)(p_238460_5_ >> 24 & 0xFF) / 255.0f;
        float f = (float)(p_238460_5_ >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(p_238460_5_ >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(p_238460_5_ & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(p_238460_0_, (float)p_238460_1_, (float)p_238460_4_, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(p_238460_0_, (float)p_238460_3_, (float)p_238460_4_, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(p_238460_0_, (float)p_238460_3_, (float)p_238460_2_, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(p_238460_0_, (float)p_238460_1_, (float)p_238460_2_, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void renderPokemon(MatrixStack matrix, PixelmonEntity pixelmon) {
        ScreenHelper.renderPokemon(matrix, pixelmon, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderPokemon(MatrixStack matrix, PixelmonEntity pixelmon, float r, float g, float b, float a) {
        RenderHelper.func_227780_a_();
        try {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            pixelmon.setRenderColor(r, g, b, a);
            EntityRenderer entityClassRenderObject = renderManager.func_78713_a((Entity)pixelmon);
            PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
            IRenderTypeBuffer.Impl buffer = ScreenHelper.getBufferImpl();
            rp.render(pixelmon, 0.0f, partialTicks, matrix, (IRenderTypeBuffer)buffer, renderManager.func_229085_a_((Entity)pixelmon, partialTicks));
            buffer.func_228461_a_();
            renderManager.func_229089_a_(Vector3f.field_229181_d_.func_229193_c_(180.0f));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void disableMinecraftUI() {
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        ForgeIngameGui.renderHotbar = false;
        ForgeIngameGui.renderObjective = false;
        ForgeIngameGui.renderHealth = false;
        ForgeIngameGui.renderArmor = false;
        ForgeIngameGui.renderAir = false;
        ForgeIngameGui.renderExperiance = false;
        ForgeIngameGui.renderHealthMount = false;
        ForgeIngameGui.renderFood = false;
    }

    public static void enableMinecraftUI() {
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
        ForgeIngameGui.renderHotbar = true;
        ForgeIngameGui.renderObjective = true;
        ForgeIngameGui.renderHealth = true;
        ForgeIngameGui.renderArmor = true;
        ForgeIngameGui.renderAir = true;
        ForgeIngameGui.renderExperiance = true;
        ForgeIngameGui.renderHealthMount = true;
        ForgeIngameGui.renderFood = true;
    }

    public static void drawItem(MatrixStack matrix, ItemStack stack, float x, float y, int srcFactor, int destFactor) {
        ScreenHelper.drawItem(matrix, stack, x, y, srcFactor, destFactor, false);
    }

    public static void drawItem(MatrixStack matrix, ItemStack stack, float x, float y, int srcFactor, int destFactor, boolean darken) {
        boolean flag;
        Minecraft mc = Minecraft.func_71410_x();
        matrix.func_227860_a_();
        IBakedModel model = mc.func_175599_af().func_184393_a(stack, null, null);
        mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        mc.field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)srcFactor, (int)destFactor);
        RenderSystem.enableColorMaterial();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderHelper.func_227780_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.func_227861_a_((double)x, (double)y, (double)(100.0f + mc.func_175599_af().field_77023_b));
        matrix.func_227861_a_(8.0, 8.0, 0.0);
        matrix.func_227862_a_(1.0f, -1.0f, 1.0f);
        matrix.func_227862_a_(16.0f, 16.0f, 16.0f);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !model.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        mc.func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrix, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, model);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        matrix.func_227865_b_();
    }
}

