/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.camera;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTarget;
import com.pixelmonmod.pixelmon.client.camera.movement.CameraMovement;
import com.pixelmonmod.pixelmon.client.camera.movement.PlayerControlledMovement;
import com.pixelmonmod.pixelmon.client.camera.movement.PositionedMovement;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class CameraEntity
extends LivingEntity {
    private CameraTarget target;
    public CameraMode mode;
    private CameraMovement movement;

    public CameraEntity(World par1World) {
        this(par1World, CameraMode.Battle);
    }

    public CameraEntity(EntityType<CameraEntity> type, World par1World) {
        this(type, par1World, CameraMode.Battle);
    }

    public CameraEntity(World par1World, CameraMode mode) {
        this((EntityType<CameraEntity>)((EntityType)EntityRegistration.CAMERA.get()), par1World, mode);
    }

    public CameraEntity(EntityType<CameraEntity> type, World par1World, CameraMode mode) {
        super(type, par1World);
        this.mode = mode;
        this.movement = PixelmonConfigProxy.getGraphics().isPlayerControlCamera() ? new PlayerControlledMovement(par1World, this) : new PositionedMovement(par1World, this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S() && (this.mode == CameraMode.Battle && ClientProxy.battleManager.battleEnded || this.mode == CameraMode.Evolution && !(Minecraft.func_71410_x().field_71462_r instanceof EvolveScreen))) {
            this.func_241204_bJ_();
            return;
        }
        if (this.func_70089_S()) {
            this.getMovement().onLivingUpdate();
        }
    }

    public HandSide func_184591_cq() {
        return null;
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType p_184201_1_, ItemStack p_184201_2_) {
    }

    public void setTarget(CameraTarget t) {
        this.target = t;
    }

    public void setTargetRandomPosition(CameraTarget t) {
        this.setTarget(t);
        this.getMovement().setRandomPosition(t);
    }

    public CameraTarget getCameraTarget() {
        return this.target;
    }

    public void updatePositionAndRotation() {
        if (Minecraft.func_71410_x().func_175606_aa() == this && this.target != null && this.target.isValidTarget()) {
            this.smoothLookAt(EntityAnchorArgument.Type.FEET, new Vector3d(this.target.getX(), this.target.getY(), this.target.getZ()));
        }
    }

    private void smoothLookAt(EntityAnchorArgument.Type anchor, Vector3d position) {
        Vector3d vector3d = anchor.func_201017_a((Entity)this);
        double d0 = position.field_72450_a - vector3d.field_72450_a;
        double d1 = position.field_72448_b - vector3d.field_72448_b;
        double d2 = position.field_72449_c - vector3d.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        this.field_70125_A = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
        this.field_70177_z = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        this.func_70034_d(this.field_70177_z);
        if (this.field_70177_z > 0.0f && this.field_70126_B < 0.0f || this.field_70177_z < 0.0f && this.field_70126_B > 0.0f) {
            this.field_70758_at = this.field_70177_z;
        }
    }

    public CameraMovement getMovement() {
        return this.movement;
    }
}

