/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.LevelRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.NoDropsRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.spawning.PixelmonSpawnerEvent;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class PixelmonSpawnerTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final Set<Material> VALID_LAND_FLOOR_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151577_b, Material.field_151593_r, Material.field_151580_n, Material.field_151592_s, Material.field_151575_d, Material.field_151578_c, Material.field_151576_e, Material.field_151595_p, Material.field_151588_w, Material.field_151597_y, Material.field_151596_z, Material.field_151598_x});
    public static final Set<Material> VALID_LAND_AIR_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151579_a, Material.field_151597_y, Material.field_151585_k, Material.field_151582_l});
    private static final Set<Material> VALID_WATER_FLOOR_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151586_h});
    private static final Set<Material> VALID_WATER_AIR_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151579_a, Material.field_151586_h});
    public List<PokemonRarity> pokemonList = Lists.newArrayList();
    public int spawnTick = 40;
    public int spawnRadius = 8;
    public int maxSpawns = 5;
    public int levelMin = 5;
    public int levelMax = 10;
    public float bossRatio = 100.0f;
    public float shinyRatio = PixelmonConfigProxy.getSpawning().getShinyRate();
    public float gmaxRatio = PixelmonConfigProxy.getSpawning().getGigantamaxFactorRate();
    public boolean uncatchable = false;
    public boolean unbreedable = false;
    public boolean unbattleable = false;
    public boolean fireOnTick = true;
    public SpawnLocationType spawnLocation = SpawnLocationType.LAND;
    public Aggression aggression = Aggression.PASSIVE;
    public List<PixelmonEntity> spawnedPokemon = Lists.newArrayList();
    private boolean editing = false;
    private int tick = -1;

    public PixelmonSpawnerTileEntity() {
        super((TileEntityType)TileEntityRegistration.PIXELMON_SPAWNER.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("spawnTick", this.spawnTick);
        nbt.func_74777_a("spawnRadius", (short)this.spawnRadius);
        nbt.func_74777_a("maxSpawns", (short)this.maxSpawns);
        nbt.func_74777_a("levelMin", (short)this.levelMin);
        nbt.func_74777_a("levelMax", (short)this.levelMax);
        nbt.func_74757_a("fireOnTick", this.fireOnTick);
        nbt.func_74777_a("aggression", (short)this.aggression.ordinal());
        nbt.func_74776_a("bossRatio", this.bossRatio);
        nbt.func_74777_a("spawnLocation", (short)this.spawnLocation.ordinal());
        nbt.func_74776_a("shinyRatio", this.shinyRatio);
        nbt.func_74776_a("gmaxRatio", this.gmaxRatio);
        nbt.func_74757_a("unbattleable", this.unbattleable);
        nbt.func_74757_a("uncatchable", this.uncatchable);
        nbt.func_74757_a("unbreedable", this.unbreedable);
        PokemonRarity.addToNbt(nbt, this.pokemonList);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.spawnTick = nbt.func_74762_e("spawnTick");
        this.spawnRadius = nbt.func_74765_d("spawnRadius");
        this.maxSpawns = nbt.func_74765_d("maxSpawns");
        this.levelMin = nbt.func_74765_d("levelMin");
        this.levelMax = nbt.func_74765_d("levelMax");
        this.fireOnTick = nbt.func_74767_n("fireOnTick");
        this.aggression = Aggression.getAggression(nbt.func_74765_d("aggression"));
        this.bossRatio = nbt.func_74760_g("bossRatio");
        this.spawnLocation = SpawnLocationType.getFromIndex(nbt.func_74765_d("spawnLocation"));
        this.shinyRatio = nbt.func_74760_g("shinyRatio");
        this.gmaxRatio = nbt.func_74760_g("gmaxRatio");
        this.unbattleable = nbt.func_74767_n("unbattleable");
        this.uncatchable = nbt.func_74767_n("uncatchable");
        this.unbreedable = nbt.func_74767_n("unbreedable");
        this.pokemonList.clear();
        this.pokemonList = PokemonRarity.fromNbt(nbt);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.fireOnTick && !this.editing) {
            this.doSpawning(false);
        } else if (this.field_145850_b.field_72995_K) {
            this.doEffects();
        }
    }

    protected static boolean isMostlyEnclosedSpace(World world, BlockPos pos, int radius) {
        for (Direction dir : Direction.values()) {
            boolean ok = false;
            for (int i = 0; i < radius; ++i) {
                BlockPos pos2 = new BlockPos(pos.func_177958_n() + dir.func_82601_c() * i, pos.func_177956_o() + dir.func_96559_d() * i, pos.func_177952_p() + dir.func_82599_e() * i);
                BlockState state = world.func_180495_p(pos2);
                if (!state.func_215686_e((IBlockReader)world, pos2)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockValidForPixelmonSpawning(World world, BlockPos pos, AreaType type) {
        BlockState groundBlock = world.func_180495_p(pos.func_177977_b());
        Material spawnFloorGroundMaterial = groundBlock.func_185904_a();
        Material[] spawnAirMaterial = new Material[]{world.func_180495_p(pos).func_185904_a(), world.func_180495_p(pos.func_177984_a()).func_185904_a()};
        if (type == AreaType.LAND) {
            return VALID_LAND_FLOOR_MATERIALS.contains(spawnFloorGroundMaterial) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[0]) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[1]);
        }
        if (type == AreaType.WATER) {
            return VALID_WATER_FLOOR_MATERIALS.contains(spawnFloorGroundMaterial) && VALID_WATER_AIR_MATERIALS.contains(spawnAirMaterial[0]) && VALID_WATER_AIR_MATERIALS.contains(spawnAirMaterial[1]);
        }
        return PixelmonSpawnerTileEntity.isMostlyEnclosedSpace(world, pos, 5) && VALID_LAND_FLOOR_MATERIALS.contains(spawnFloorGroundMaterial) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[0]) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[1]);
    }

    private void spawnPixelmon(PokemonSpecification spec) {
        Integer ytmp;
        this.checkForDead();
        if (this.spawnedPokemon.size() >= this.maxSpawns) {
            return;
        }
        if (this.spawnLocation == null) {
            return;
        }
        int x = this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(this.spawnRadius * 2 + 1) - this.spawnRadius;
        int y = this.field_174879_c.func_177956_o() - 1;
        int z = this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(this.spawnRadius * 2 + 1) - this.spawnRadius;
        boolean valid = false;
        if (this.spawnLocation == SpawnLocationType.LAND) {
            y = this.getTopSolidBlock(x, y, z);
            valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.field_145850_b, new BlockPos(x, y, z), AreaType.LAND);
        } else if (this.spawnLocation == SpawnLocationType.AIR) {
            y = this.getTopSolidBlock(x, y, z);
            valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.field_145850_b, new BlockPos(x, y, z), AreaType.LAND);
        } else if (this.spawnLocation == SpawnLocationType.AIR_PERSISTENT) {
            ytmp = this.getFirstAirBlock(x, y, z);
            if (ytmp != null) {
                y = ytmp;
                valid = true;
            }
        } else if (this.spawnLocation == SpawnLocationType.WATER) {
            ytmp = this.getFirstWaterBlock(x, y, z);
            if (ytmp != null) {
                y = ytmp;
                valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.field_145850_b, new BlockPos(x, y + 1, z), AreaType.WATER);
            }
        } else if (this.spawnLocation == SpawnLocationType.UNDERGROUND) {
            y = this.getTopSolidBlock(x, y, z);
            valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.field_145850_b, new BlockPos(x, y, z), AreaType.UNDERGROUND);
        }
        if (valid) {
            PixelmonSpawnerEvent.Pre event = new PixelmonSpawnerEvent.Pre(this, spec, new BlockPos(x, y, z));
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return;
            }
            PixelmonEntity pixelmon = event.getSpec().create(this.field_145850_b);
            pixelmon.func_70107_b(x, y, z);
            if (!event.getSpec().getValue(LevelRequirement.class).isPresent()) {
                pixelmon.getPokemon().setLevel(RandomHelper.getRandomNumberBetween(this.levelMin, this.levelMax));
            }
            if (!event.getSpec().getValue(ShinyRequirement.class).isPresent() && !event.getSpec().getValue(PaletteRequirement.class).isPresent() && RandomHelper.getRandomChance(1.0f / this.shinyRatio)) {
                pixelmon.getPokemon().setShiny();
            }
            if (RandomHelper.getRandomChance(1.0f / this.gmaxRatio)) {
                List<Stats> forms = pixelmon.getSpecies().getForms("gmax");
                if (forms.size() > 1) {
                    pixelmon.setForm(RandomHelper.getRandomElementFromCollection(forms));
                } else if (!forms.isEmpty()) {
                    pixelmon.setForm(forms.get(0));
                }
            }
            if (this.uncatchable) {
                pixelmon.getPokemon().addFlag("uncatchable");
            }
            if (this.unbreedable) {
                pixelmon.getPokemon().addFlag("unbreedable");
            }
            if (this.unbattleable) {
                pixelmon.getPokemon().addFlag("unbattleable");
            }
            if (event.getSpec().getValue(NoDropsRequirement.class).isPresent()) {
                pixelmon.getPokemon().addFlag("nodrops");
            }
            pixelmon.resetDataWatchers();
            this.field_145850_b.func_217376_c((Entity)pixelmon);
            pixelmon.aggression = this.aggression;
            pixelmon.setSpawnLocation(this.spawnLocation);
            pixelmon.resetAI();
            pixelmon.setSpawnerParent(this);
            this.spawnedPokemon.add(pixelmon);
            Pixelmon.EVENT_BUS.post((Event)new PixelmonSpawnerEvent.Post(this, event.getSpec(), event.getSpawnPosition(), pixelmon));
        }
    }

    private int getTopSolidBlock(int x, int y, int z) {
        Material blockMaterial;
        BlockPos pos;
        int i;
        boolean valid = false;
        for (i = 1; i <= this.spawnRadius / 2; ++i) {
            pos = new BlockPos(x, y + i, z);
            blockMaterial = this.field_145850_b.func_180495_p(pos).func_185904_a();
            if (!VALID_LAND_AIR_MATERIALS.contains(blockMaterial) || !this.isSolidSurface(this.field_145850_b, pos)) continue;
            y += i;
            valid = true;
            break;
        }
        if (!valid) {
            for (i = 1; i <= this.spawnRadius / 2; ++i) {
                pos = new BlockPos(x, y - i, z);
                blockMaterial = this.field_145850_b.func_180495_p(pos).func_185904_a();
                if (!VALID_LAND_AIR_MATERIALS.contains(blockMaterial) || !this.isSolidSurface(this.field_145850_b, pos)) continue;
                y -= i;
                break;
            }
        }
        return y;
    }

    private boolean isSolidSurface(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)worldIn, pos, Direction.UP) && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    private Integer getFirstAirBlock(int x, int y, int z) {
        int i = 0;
        while (this.field_145850_b.func_180495_p(new BlockPos(x, y + i, z)).func_185904_a() != Material.field_151579_a) {
            if (i > this.spawnRadius / 2) {
                return null;
            }
            ++i;
        }
        return y + i;
    }

    private Integer getFirstWaterBlock(int x, int y, int z) {
        int i = 0;
        while (this.field_145850_b.func_180495_p(new BlockPos(x, y + i, z)).func_185904_a() != Material.field_151586_h) {
            if (this.field_145850_b.func_180495_p(new BlockPos(x, y + i, z)).func_185904_a() == Material.field_151579_a) {
                return null;
            }
            ++i;
        }
        return y + i;
    }

    private void doSpawning(boolean override) {
        if (this.tick == 0 || override) {
            PokemonSpecification p = this.selectPokemonForSpawn();
            if (p == null) {
                return;
            }
            this.spawnPixelmon(p);
            this.resetSpawnTick();
            if (override) {
                return;
            }
        }
        if (this.tick == -1) {
            this.resetSpawnTick();
        }
        --this.tick;
    }

    private void doEffects() {
        if (this.isNearPlayer()) {
            World world = this.func_145831_w();
            BlockPos blockpos = this.func_174877_v();
            if (!(world instanceof ServerWorld)) {
                double d3 = (double)blockpos.func_177958_n() + world.field_73012_v.nextDouble();
                double d4 = (double)blockpos.func_177956_o() + world.field_73012_v.nextDouble();
                double d5 = (double)blockpos.func_177952_p() + world.field_73012_v.nextDouble();
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, d3, d4, d5, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean isNearPlayer() {
        BlockPos blockpos = this.func_174877_v();
        return this.func_145831_w().func_217358_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, 16.0);
    }

    private void checkForDead() {
        for (int i = 0; i < this.spawnedPokemon.size(); ++i) {
            PixelmonEntity p = this.spawnedPokemon.get(i);
            if (p.isLoaded(false) && p.func_70089_S()) continue;
            this.spawnedPokemon.remove(i);
            --i;
        }
    }

    private void resetSpawnTick() {
        this.tick = (int)((double)this.spawnTick * (1.0 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.2));
    }

    private PokemonSpecification selectPokemonForSpawn() {
        int total = 0;
        for (PokemonRarity aPokemonList1 : this.pokemonList) {
            total += aPokemonList1.rarity;
        }
        if (total <= 0) {
            return null;
        }
        int rand = this.field_145850_b.field_73012_v.nextInt(total);
        total = 0;
        for (PokemonRarity aPokemonList : this.pokemonList) {
            if (rand >= (total += aPokemonList.rarity)) continue;
            return aPokemonList.pokemon;
        }
        return null;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void updateRedstone() {
        if (!this.fireOnTick && !this.editing) {
            this.doSpawning(true);
        }
    }

    public void onActivate() {
        this.editing = true;
    }

    public void finishEdit() {
        this.editing = false;
        this.resetSpawnTick();
        while (!this.spawnedPokemon.isEmpty()) {
            this.spawnedPokemon.get(0).unloadEntity();
            this.spawnedPokemon.remove(0);
        }
        for (int i = 0; i < this.pokemonList.size(); ++i) {
            PokemonRarity pkr = this.pokemonList.get(i);
            if (pkr.pokemon.toString().length() <= 0) continue;
            pkr.pokemon = PokemonSpecificationProxy.create(pkr.pokemon.toString());
        }
    }

    public void despawnAllPokemon() {
        while (!this.spawnedPokemon.isEmpty()) {
            this.spawnedPokemon.get(0).unloadEntity();
            this.spawnedPokemon.remove(0);
        }
    }

    public static enum AreaType {
        LAND,
        WATER,
        UNDERGROUND;

    }
}

