/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.tileentity.TradeMachineTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TradeMachineBlock
extends MultiBlock
implements IBlockHasOwner {
    private DyeColor color;

    public TradeMachineBlock(DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.5f).func_200947_a(SoundType.field_185851_d).func_226896_b_(), 3, 1.875, 1, true);
        this.color = color;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_201670_d() || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        pos = this.findBaseBlock((IBlockReader)world, pos.func_239590_i_(), state);
        if (!(player.field_71070_bA instanceof PlayerContainer)) {
            return ActionResultType.FAIL;
        }
        TradeMachineTileEntity tileEntityTradeMachine = BlockHelper.getTileEntity(TradeMachineTileEntity.class, (IBlockReader)world, pos);
        if (tileEntityTradeMachine != null) {
            if (tileEntityTradeMachine.playerCount < 2) {
                tileEntityTradeMachine.registerPlayer((ServerPlayerEntity)player);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.tradefull", new Object[0]);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        if (state.func_177229_b(MultiBlock.MULTIPOS) == MultiBlockPosition.BASE) {
            return BlockRenderType.MODEL;
        }
        return super.func_149645_b(state);
    }

    @Override
    protected Optional<TileEntity> getTileEntity(IBlockReader world, BlockState state) {
        return Optional.of(new TradeMachineTileEntity());
    }

    @Override
    public void setOwner(BlockPos pos, PlayerEntity playerIn) {
        TradeMachineTileEntity tileEntityTradeMachine = BlockHelper.getTileEntity(TradeMachineTileEntity.class, (IBlockReader)playerIn.func_130014_f_(), pos);
        tileEntityTradeMachine.setOwner(playerIn.func_110124_au());
    }
}

