/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.enums.ShrineType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.BirdShrineTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShrineBlock
extends GenericRotatableModelBlock {
    public static final BooleanProperty USED = BooleanProperty.func_177716_a((String)"used");
    private ShrineType rockType;

    public ShrineBlock(ShrineType rockType) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_208770_d().func_226896_b_().func_200948_a(-1.0f, 6000000.0f).func_200944_c());
        this.rockType = rockType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)USED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{USED});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)USED, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.rockType == ShrineType.ARTICUNO) {
            return new ItemStack((IItemProvider)Item.func_150898_a((Block)PixelmonBlocks.articuno_shrine));
        }
        if (this.rockType == ShrineType.ZAPDOS) {
            return new ItemStack((IItemProvider)Item.func_150898_a((Block)PixelmonBlocks.zapdos_shrine));
        }
        if (this.rockType == ShrineType.MOLTRES) {
            return new ItemStack((IItemProvider)Item.func_150898_a((Block)PixelmonBlocks.moltres_shrine));
        }
        return null;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BirdShrineTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        BirdShrineTileEntity tile = BlockHelper.getTileEntity(BirdShrineTileEntity.class, (IBlockReader)world, pos);
        if (tile != null) {
            tile.activate(player, this, state, heldItem);
            world.func_175666_e(pos, state.func_177230_c());
            world.func_175666_e(pos, (Block)this);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean getIsUsed(BirdShrineTileEntity tile) {
        return (Boolean)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b((Property)USED);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_175666_e(pos, state.func_177230_c());
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        world.func_175666_e(pos, state.func_177230_c());
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        BirdShrineTileEntity tile = (BirdShrineTileEntity)blockAccess.func_175625_s(pos);
        if (this.getIsUsed(tile)) {
            return 15;
        }
        return 0;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            BlockItem.func_179224_a((World)worldIn, (PlayerEntity)((PlayerEntity)placer), (BlockPos)pos, (ItemStack)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public ShrineType getRockType() {
        return this.rockType;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }
}

