/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import java.util.Locale;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class TemplePillarBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    public static final EnumProperty<State> NORTH = EnumProperty.func_177709_a((String)"north", State.class);
    public static final EnumProperty<State> EAST = EnumProperty.func_177709_a((String)"east", State.class);
    public static final EnumProperty<State> SOUTH = EnumProperty.func_177709_a((String)"south", State.class);
    public static final EnumProperty<State> WEST = EnumProperty.func_177709_a((String)"west", State.class);
    public static final EnumProperty<State> UP = EnumProperty.func_177709_a((String)"up", State.class);
    public static final EnumProperty<State> DOWN = EnumProperty.func_177709_a((String)"down", State.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public TemplePillarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)((Object)State.AIR))).func_206870_a(EAST, (Comparable)((Object)State.AIR))).func_206870_a(SOUTH, (Comparable)((Object)State.AIR))).func_206870_a(WEST, (Comparable)((Object)State.AIR))).func_206870_a(UP, (Comparable)((Object)State.AIR))).func_206870_a(DOWN, (Comparable)((Object)State.AIR))).func_206870_a(AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.calculate((BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)context.func_196000_l().func_176740_k()), (IWorld)context.func_195991_k(), context.func_195995_a(), context.func_196000_l());
    }

    private BlockState calculate(BlockState state, IWorld level, BlockPos pos, Direction clickedFace) {
        EnumProperty<State> backwardProperty;
        EnumProperty<State> forwardProperty;
        if (clickedFace.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL) {
            if (clickedFace.func_176740_k() == Direction.Axis.X) {
                if (clickedFace == Direction.EAST) {
                    forwardProperty = EAST;
                    backwardProperty = WEST;
                } else {
                    forwardProperty = WEST;
                    backwardProperty = EAST;
                }
            } else if (clickedFace == Direction.NORTH) {
                forwardProperty = NORTH;
                backwardProperty = SOUTH;
            } else {
                forwardProperty = SOUTH;
                backwardProperty = NORTH;
            }
        } else if (clickedFace == Direction.UP) {
            forwardProperty = UP;
            backwardProperty = DOWN;
        } else {
            forwardProperty = DOWN;
            backwardProperty = UP;
        }
        BlockPos forward = pos.func_241872_a(clickedFace.func_176740_k(), clickedFace.func_176730_m().func_243648_a(clickedFace.func_176740_k()));
        BlockPos backward = pos.func_241872_a(clickedFace.func_176740_k(), -clickedFace.func_176730_m().func_243648_a(clickedFace.func_176740_k()));
        BlockState forwardState = level.func_180495_p(forward);
        BlockState backwardState = level.func_180495_p(backward);
        state = (BlockState)((BlockState)state.func_206870_a(forwardProperty, (Comparable)((Object)this.calcTempleState(level, clickedFace, forward, forwardState)))).func_206870_a(backwardProperty, (Comparable)((Object)this.calcTempleState(level, clickedFace.func_176734_d(), backward, backwardState)));
        if (level.func_180495_p(pos).func_204520_s().func_206889_d()) {
            state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private State calcTempleState(IWorld level, Direction direction, BlockPos pos, BlockState state) {
        if (state.func_203425_a(Blocks.field_150350_a)) {
            return State.AIR;
        }
        if (state.func_203425_a((Block)PixelmonBlocks.temple_pillar) || state.func_203425_a((Block)PixelmonBlocks.temple_pillar_fractured)) {
            return State.PILLAR;
        }
        if (state.func_224755_d((IBlockReader)level, pos, direction.func_176734_d())) {
            return State.SOLID;
        }
        return State.AIR;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        super.func_206840_a(p_206840_1_);
        p_206840_1_.func_206894_a(new Property[]{AXIS, NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    public BlockState func_185499_a(BlockState state, Rotation direction) {
        return this.rotate(state, null, null, direction);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        block0 : switch (direction) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        state = (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                        break block0;
                    }
                    case Z: {
                        state = (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
            }
        }
        State oldNorth = (State)((Object)state.func_177229_b(NORTH));
        switch (direction) {
            case COUNTERCLOCKWISE_90: {
                state = (BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST));
                state = (BlockState)state.func_206870_a(EAST, state.func_177229_b(SOUTH));
                state = (BlockState)state.func_206870_a(SOUTH, state.func_177229_b(WEST));
                state = (BlockState)state.func_206870_a(WEST, (Comparable)((Object)oldNorth));
                break;
            }
            case CLOCKWISE_90: {
                state = (BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST));
                state = (BlockState)state.func_206870_a(WEST, state.func_177229_b(SOUTH));
                state = (BlockState)state.func_206870_a(SOUTH, state.func_177229_b(EAST));
                state = (BlockState)state.func_206870_a(EAST, (Comparable)((Object)oldNorth));
                break;
            }
            case CLOCKWISE_180: {
                state = (BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH));
                state = (BlockState)state.func_206870_a(SOUTH, (Comparable)((Object)oldNorth));
                State oldWest = (State)((Object)state.func_177229_b(WEST));
                state = (BlockState)state.func_206870_a(WEST, state.func_177229_b(EAST));
                state = (BlockState)state.func_206870_a(EAST, (Comparable)((Object)oldWest));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorType) {
        switch (mirrorType) {
            case FRONT_BACK: {
                State oldWest = (State)((Object)state.func_177229_b(WEST));
                state = (BlockState)state.func_206870_a(WEST, state.func_177229_b(EAST));
                state = (BlockState)state.func_206870_a(EAST, (Comparable)((Object)oldWest));
                break;
            }
            case LEFT_RIGHT: {
                State oldNorth = (State)((Object)state.func_177229_b(NORTH));
                state = (BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH));
                state = (BlockState)state.func_206870_a(SOUTH, (Comparable)((Object)oldNorth));
            }
        }
        return state;
    }

    public static enum State implements IStringSerializable
    {
        SOLID,
        AIR,
        PILLAR;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

