/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Protect;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class SilkTrap
extends Protect {
    public SilkTrap() {
        super(StatusType.SilkTrap);
    }

    @Override
    protected boolean addStatus(PixelmonWrapper user) {
        return user.addStatus(new SilkTrap(), user);
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (super.stopsIncomingAttack(pokemon, user) && user.attack.getAttackCategory() != AttackCategory.STATUS) {
            if (user.attack.getMove().getMakesContact()) {
                user.getBattleStats().modifyStat(-1, BattleStatsType.SPEED);
            }
            return true;
        }
        return false;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        super.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        if (userChoice.weight != -1.0f) {
            block0: for (List<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
                for (MoveChoice choice : choices) {
                    if (!choice.isAttack() || !choice.attack.getMove().getMakesContact()) continue;
                    userChoice.raiseWeight(12.5f);
                    continue block0;
                }
            }
        }
    }
}

