/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Protect;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.List;

public class KingsShield
extends Protect {
    public KingsShield() {
        super(StatusType.KingsShield);
    }

    @Override
    protected boolean addStatus(PixelmonWrapper user) {
        return user.addStatus(new KingsShield(), user);
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return user.attack.getAttackCategory() != AttackCategory.STATUS && super.stopsIncomingAttack(pokemon, user);
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        super.stopsIncomingAttackMessage(pokemon, user);
        if (user.attack.getMove().getMakesContact()) {
            user.getBattleStats().modifyStat(-1, BattleStatsType.ATTACK, user, false);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        super.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        if (userChoice.weight != -1.0f) {
            StatsEffect statsEffect = new StatsEffect(BattleStatsType.ATTACK, -1, false);
            block0: for (List<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
                for (MoveChoice choice : choices) {
                    if (!choice.isAttack() || !choice.attack.getMove().getMakesContact()) continue;
                    List<PixelmonWrapper> saveTargets = userChoice.targets;
                    ArrayList<PixelmonWrapper> newTargets = new ArrayList<PixelmonWrapper>();
                    newTargets.add(choice.user);
                    userChoice.targets = newTargets;
                    statsEffect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
                    userChoice.targets = saveTargets;
                    continue block0;
                }
            }
        }
    }
}

